@extends("layouts.app")

@section("content")
<div class="container">
    <h1>Accessory Details</h1>
    <div class="card">
        <div class="card-body">
            <h5 class="card-title">{{ $accessory->name }}</h5>
            <p class="card-text"><strong>Consumption per Unit:</strong> {{ $accessory->consumption_per_unit }}</p>
            <p class="card-text"><strong>Default Rate:</strong> {{ $accessory->default_rate }} USD</p>
            <p class="card-text"><strong>Unit:</strong> {{ $accessory->unit }}</p>
            <p class="card-text"><strong>Description:</strong> {{ $accessory->description }}</p>
            <p class="card-text"><strong>Status:</strong> {{ $accessory->is_active ? "Active" : "Inactive" }}</p>
            <a href="{{ route("accessories.edit", $accessory->id) }}" class="btn btn-warning">Edit</a>
            <a href="{{ route("accessories.index") }}" class="btn btn-secondary">Back to List</a>
        </div>
    </div>
</div>
@endsection


