@include('admin.header') 

<style >label{
    font-weight: 700;
}</style>
<div class="container bg-white p-3">
    <h1>Edit Accessory</h1>
    <form action="{{ route('admin.accessories.update', $accessory->id) }}" method="POST">
        @csrf
        @method("PUT")
        <div class="mb-3">
            <label for="name" class="form-label">Name</label>
            <input type="text" class="form-control" id="name" name="name" value="{{ $accessory->name }}" required>
        </div>
        <div class="mb-3">
            <label for="consumption_per_unit" class="form-label">Consumption per Unit</label>
            <input type="number" step="0.0001" class="form-control" id="consumption_per_unit" name="consumption_per_unit" value="{{ $accessory->consumption_per_unit }}" required>
        </div>
        <div class="mb-3">
            <label for="default_rate" class="form-label">Default Rate (USD)</label>
            <input type="number" step="0.01" class="form-control" id="default_rate" name="default_rate" value="{{ $accessory->default_rate }}" required>
        </div>
        <div class="mb-3">
            <label for="unit" class="form-label">Unit</label>
            <input type="text" class="form-control" id="unit" name="unit" value="{{ $accessory->unit }}" required>
        </div>
        <div class="mb-3">
            <label for="description" class="form-label">Description</label>
            <textarea class="form-control" id="description" name="description">{{ $accessory->description }}</textarea>
        </div>
        <div class="mb-3 form-check">
            <input type="checkbox" class="form-check-input" id="is_active" name="is_active" value="1" {{ $accessory->is_active ? "checked" : "" }}>
            <label class="form-check-label" for="is_active">Active</label>
        </div>
        <button type="submit" class="btn btn-primary">Update</button>
        <a href="{{ route('admin.accessories.index') }}" class="btn btn-secondary">Cancel</a>
    </form>
</div>
@include('admin.footer') 


