@include('admin.header')

<div class="container">
    <h2>Information Library</h2>
    <a class="btn btn-primary mb-3 float-right mb-2" href="{{ route('admin.information-library.create') }}">   <i class="fas fa-plus"></i> Add New</a>

       @if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="zmdi zmdi-check-circle"></i> {{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif
    <div class="table-responsive">

    <table class="table table-bordered table-striped">
        <thead class="thead-dark">
            <tr>
   <th>#</th>
                    <th>Type</th>
                    <th>Category</th>
                    <th>Name</th>
                    <th>GSM</th>
                    <th>Wastage %</th>
                    <th>Unit</th>
                    <th>Rate</th>
                    <th>description</th>
                    <th>Status</th>
                    <th>Effective From</th>
                    <th width="150px">Actions</th>            </tr>
        </thead>
        <tbody>
            @forelse($items as $index => $item)
                <tr>
                    <td>{{ $items->firstItem() + $index }}</td>
                    <td>{{ ucfirst($item->type) }}</td>
                    <td>{{ $item->category }}</td>
                    <td>{{ $item->name }}</td>
                    <td>{{ $item->gsm ?? '-' }}</td>
                    <td>{{ $item->wastage_percent ? $item->wastage_percent . '%' : '-' }}</td>
                    <td>{{ $item->unit }}</td>
                    <td>{{ $item->rate }}</td>
                    <td>{{ $item->description }}</td>
                    <td>
                        <span class="badge badge-{{ $item->status == 'active' ? 'success' : 'secondary' }}">
                            {{ ucfirst($item->status) }}
                        </span>
                    </td>
                    <td>{{ $item->effective_from ?? '-' }}</td>
                <td>
<div class="dropdown">
    <button class="btn btn-primary btn-sm dropdown-toggle" type="button" id="buyerActionsDropdown" data-bs-toggle="dropdown" aria-expanded="false">
        Actions
    </button>
    <ul class="dropdown-menu" aria-labelledby="buyerActionsDropdown">
<li>    <a href="{{ route('admin.information-library.edit', $item->id) }}" class="dropdown-item "><i class="fas fa-edit"></i> Update </a>
</li>

<li>
    
                    <form action="{{ route('admin.information-library.destroy', $item->id) }}" method="POST" style="display:inline;">
                        @csrf @method('DELETE')
                        <button type="submit" class="dropdown-item "
                            onclick="return confirm('Are you sure?')"><i class="fas fa-trash"></i> Remove</button>
                    </form>

</li>

</ul>

</div>



                
                </td>
            </tr>

                 @empty
                <tr>
                    <td colspan="11" class="text-center">No records found.</td>
                </tr>
                @endforelse
        </tbody>
    </table>

</div>
</div>

<div class="d-flex justify-content-center mt-4">
    {{ $items->links() }}
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

@include('admin.footer')
