@include('admin.header')

<div class="container">
    <h3 class="mb-4">Update Information Item</h3>

    @if($errors->any())
        <div class="alert alert-danger">
            <strong>Oops!</strong> Please fix the following errors:
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('admin.information-library.update', $informationLibrary->id) }}" method="POST">
        @method('PUT')
        @csrf
        @include('admin.information-library.form', ['item' => $informationLibrary])
        <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Update</button>
        <a href="{{ route('admin.information-library.index') }}" class="btn btn-secondary"><i class="fas fa-times"></i> Cancel</a>
    </form>
</div>

@include('admin.footer')