@include('admin.header')
<style >
.modal-backdrop.show{
    opacity: 0!important;
}
.modal-backdrop{
    z-index: 0!important;
}
.modal {
  z-index: 1055!important;

}
</style>
<div class="container bg-white p-3">
    <ul class="nav nav-tabs" id="dropdownTabs" role="tablist">
        <li class="nav-item">
            <a class="nav-link active" id="brand-tab" data-toggle="tab" href="#brand" role="tab">Brand</a>
        </li>
    <li class="nav-item">
    <a class="nav-link" data-toggle="tab" href="#item-description">Item Description</a>
</li>

    </ul>

    <div class="tab-content mt-3" id="dropdownTabsContent">

<!-- Item Description Tab -->
<div class="tab-pane fade" id="item-description" role="tabpanel">
    <!-- Add Item Description Form -->
    <form action="{{ route('admin.item-descriptions.store') }}" method="POST" class="mb-3">
        @csrf
        <div class="row">
            <div class="col-12 col-md-9 mb-2">
                <label style="font-weight: 800;">Enter Item Description</label>
                <input type="text" name="name" class="form-control bg-light" placeholder="Enter description" required>
            </div>
            <div class="col-12 col-md-3">
                <button class="btn btn-primary w-100"><i class="fas fa-plus"></i> Add</button>
            </div>
        </div>
    </form>


    <!-- Description List -->
    <ul class="list-group">
        @foreach($descriptions as $desc)
        <li class="list-group-item" id="item-description-item-{{ $desc->id }}">
            <div class="row align-items-center">
                <!-- Display -->
                <div class="col-12 col-md-2 mb-2 bg-light p-1" id="item-description-display-{{ $desc->id }}">
                    {{ $desc->name }}
                </div>

                <!-- Edit Form -->
                <div class="col-12 col-md-5 mb-2 d-none" id="item-description-edit-form-{{ $desc->id }}">
                    <form action="{{ route('admin.item-descriptions.update', $desc->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="input-group">
                            <input type="text" name="name" value="{{ $desc->name }}" class="form-control bg-light" required>
                            <div class="input-group-append">
                                <button class="btn btn-success btn-sm" type="submit"><i class="fas fa-edit"></i> Update</button>
                                <button type="button" class="btn btn-secondary btn-sm" onclick="cancelItemDescEdit({{ $desc->id }})"><i class="fas fa-times"></i> Cancel</button>
                            </div>
                        </div>
                    </form>
                </div>

                <!-- Buttons -->
                <div class="col-12 col-md-3 text-md-right">
                    <button class="btn btn-sm btn-primary mb-1" onclick="editItemDescription({{ $desc->id }})">
                        <i class="fas fa-edit"></i> Update
                    </button>
                    <form action="{{ route('admin.item-descriptions.destroy', $desc->id) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-sm btn-danger mb-1">
                            <i class="fas fa-trash"></i> Delete
                        </button>
                    </form>
                </div>
            </div>
        </li>
        @endforeach
    </ul>

    <div class="d-flex justify-content-center mt-4">
    {{ $descriptions->links() }}
</div>
</div>







        <!-- Brand Tab -->
        <div class="tab-pane fade show active" id="brand" role="tabpanel">
            <!-- Add Brand Form -->
            <form action="{{ route('admin.brands.store') }}" method="POST" class="mb-3">
                @csrf
                <div class="row">
                    <div class="col-12 col-md-9 mb-2">
                         <label style="font-weight: 800;">Enter Brand Name</label>
                        <input type="text" name="name" class="form-control bg-light" placeholder="Enter brand" required>
                    </div>
                    <div class="col-12 col-md-3">
                        <button class="btn btn-primary w-100"><i class="fas fa-plus"></i> Add</button>
                    </div>
                </div>
            </form>

         

            <!-- Brand List -->
            <ul class="list-group">
                @foreach($brands as $brand)
                <li class="list-group-item" id="brand-item-{{ $brand->id }}">
                    <div class="row align-items-center">
                        <!-- Brand Display -->

                        <div class="col-12 col-md-2 mb-2 bg-light p-1" id="brand-display-{{ $brand->id }}">
                            {{ $brand->name }}
                        </div>

                        <!-- Edit Form (Hidden by Default) -->
                        <div class="col-12 col-md-5 mb-2 d-none" id="brand-edit-form-{{ $brand->id }}">
                            <form action="{{ route('admin.brands.update', $brand->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="input-group">
                                    <input type="text" name="name" value="{{ $brand->name }}" class="form-control bg-light" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-success btn-sm" type="submit"><i class="fas fa-edit"></i> Update</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="cancelEdit({{ $brand->id }})"><i class="fas fa-times"></i> Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>

                        <!-- Buttons -->
                        <div class="col-12 col-md-3 text-md-right">
                            <button class="btn btn-sm btn-primary mb-1" onclick="editBrand({{ $brand->id }})">
                                <i class="fas fa-edit"></i> Update
                            </button>
                            <form action="{{ route('admin.brands.destroy', $brand->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger mb-1">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>

    <div class="d-flex justify-content-center mt-4">
    {{ $brands->links() }}
</div>
        </div>

    </div>
</div>
<script>// success message code
   document.addEventListener("DOMContentLoaded", function () {
        @if (session('success'))
            Swal.fire({
                title: 'Success!',
                text: '{{ session('success') }}',
                icon: 'success',
                confirmButtonText: 'OK'
            });
        @endif

        @if (session('success_item'))
            Swal.fire({
                title: 'Success!',
                text: '{{ session('success_item') }}',
                icon: 'success',
                confirmButtonText: 'OK'
            });
        @endif
    });</script>

@include('admin.footer')
