@include('admin.header')
<style >
.modal-backdrop.show{
    opacity: 0!important;
}
.modal-backdrop{
    z-index: 0!important;
}
.modal {
  z-index: 1055!important;

}
</style>
<div class="container bg-white p-3">
    <ul class="nav nav-tabs border rounded p-3 " id="dropdownTabs" role="tablist">
        <li class="nav-item">
            <a class="nav-link active" id="brand-tab-link" data-toggle="tab" href="#brand-tab" role="tab">Brand</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="item-description-tab-link" data-toggle="tab" href="#item-description-tab" role="tab">Item Description</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="size-range-tab-link" data-toggle="tab" href="#size-range-tab" role="tab">Size Range</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="color-tab-link" data-toggle="tab" href="#color-tab" role="tab">Color</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="fabric-composition-tab-link" data-toggle="tab" href="#fabric-composition-tab" role="tab">Fabric Composition</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="fabric-type-tab-link" data-toggle="tab" href="#fabric-type-tab" role="tab">Fabric Type</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="yarn-count-tab-link" data-toggle="tab" href="#yarn-count-tab" role="tab">Yarn Count</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="fabric-weight-tab-link" data-toggle="tab" href="#fabric-weight-tab" role="tab">Fabric Weight/GSM</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="port-of-landing-tab-link" data-toggle="tab" href="#port-of-landing-tab" role="tab">Port of Landing</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="country-of-origin-tab-link" data-toggle="tab" href="#country-of-origin-tab" role="tab">Country of Origin</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="port-of-discharge-tab-link" data-toggle="tab" href="#port-of-discharge-tab" role="tab">Port of Discharge</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="final-destination-tab-link" data-toggle="tab" href="#final-destination-tab" role="tab">Final Destination</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="delivery-term-tab-link" data-toggle="tab" href="#delivery-term-tab" role="tab">Delivery Terms</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="shipment-mode-tab-link" data-toggle="tab" href="#shipment-mode-tab" role="tab">Shipment Mode</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="payment-term-tab-link" data-toggle="tab" href="#payment-term-tab" role="tab">Payment Terms</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="payment-mode-tab-link" data-toggle="tab" href="#payment-mode-tab" role="tab">Payment Mode</a>
        </li>
    </ul>

    <div class="tab-content mt-3" id="dropdownTabsContent">

        <!-- Brand Tab -->
        <div class="tab-pane fade show active" id="brand-tab" role="tabpanel">
            <form action="{{ route('admin.brands.store') }}" method="POST" class="mb-3">
                @csrf
                <div class="row">
                    <div class="col-12 col-md-9 mb-2">
                         <label style="font-weight: 800;">Enter Brand Name</label>
                        <input type="text" name="name" class="form-control bg-light" placeholder="Enter brand" required>
                    </div>
                    <div class="col-12 col-md-3">
                        <button class="btn btn-primary w-100" style="margin-top: 33px;"><i class="fas fa-plus"></i> Add</button>
                    </div>
                </div>
            </form>
            <ul class="list-group">
                @foreach($brands as $brand)
                <li class="list-group-item" id="brand-item-{{ $brand->id }}">
                    <div class="row align-items-center">
                        <div class="col-12 col-md-2 mb-2 bg-light p-1" id="brand-display-{{ $brand->id }}">
                            {{ $brand->name }}
                        </div>
                        <div class="col-12 col-md-5 mb-2 d-none" id="brand-edit-form-{{ $brand->id }}">
                            <form action="{{ route('admin.brands.update', $brand->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="input-group">
                                    <input type="text" name="name" value="{{ $brand->name }}" class="form-control bg-light" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-success btn-sm" type="submit"><i class="fas fa-edit"></i> Update</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="cancelEdit({{ $brand->id }}, 'brand')"><i class="fas fa-times"></i> Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-md-3 text-md-right">
                            <button class="btn btn-sm btn-primary mb-1" onclick="editItem({{ $brand->id }}, 'brand')">
                                <i class="fas fa-edit"></i> Update
                            </button>
                            <form action="{{ route('admin.brands.destroy', $brand->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger mb-1">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>
            <div class="d-flex justify-content-center mt-4">
                {{ $brands->links() }}
            </div>
        </div>

        <!-- Item Description Tab -->
        <div class="tab-pane fade" id="item-description-tab" role="tabpanel">
            <form action="{{ route('admin.item-descriptions.store') }}" method="POST" class="mb-3">
                @csrf
                <div class="row">
                    <div class="col-12 col-md-9 mb-2">
                        <label style="font-weight: 800;">Enter Item Description</label>
                        <input type="text" name="name" class="form-control bg-light" placeholder="Enter description" required>
                    </div>
                    <div class="col-12 col-md-3">
                        <button class="btn btn-primary w-100" style="margin-top: 33px;"><i class="fas fa-plus"></i> Add</button>
                    </div>
                </div>
            </form>
            <ul class="list-group">
                @foreach($descriptions as $desc)
                <li class="list-group-item" id="item-description-item-{{ $desc->id }}">
                    <div class="row align-items-center">
                        <div class="col-12 col-md-2 mb-2 bg-light p-1" id="item-description-display-{{ $desc->id }}">
                            {{ $desc->name }}
                        </div>
                        <div class="col-12 col-md-5 mb-2 d-none" id="item-description-edit-form-{{ $desc->id }}">
                            <form action="{{ route('admin.item-descriptions.update', $desc->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="input-group">
                                    <input type="text" name="name" value="{{ $desc->name }}" class="form-control bg-light" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-success btn-sm" type="submit"><i class="fas fa-edit"></i> Update</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="cancelEdit({{ $desc->id }}, 'item-description')"><i class="fas fa-times"></i> Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-md-3 text-md-right">
                            <button class="btn btn-sm btn-primary mb-1" onclick="editItem({{ $desc->id }}, 'item-description')">
                                <i class="fas fa-edit"></i> Update
                            </button>
                            <form action="{{ route('admin.item-descriptions.destroy', $desc->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger mb-1">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>
            <div class="d-flex justify-content-center mt-4">
                {{ $descriptions->links() }}
            </div>
        </div>

        <!-- Size Range Tab -->
        <div class="tab-pane fade" id="size-range-tab" role="tabpanel">
            <form action="{{ route('admin.size-ranges.store') }}" method="POST" class="mb-3">
                @csrf
                <div class="row">
                    <div class="col-12 col-md-9 mb-2">
                        <label style="font-weight: 800;">Enter Size Range</label>
                        <input type="text" name="name" class="form-control bg-light" placeholder="Enter size range" required>
                    </div>
                    <div class="col-12 col-md-3">
                        <button class="btn btn-primary w-100" style="margin-top: 33px;"><i class="fas fa-plus"></i> Add</button>
                    </div>
                </div>
            </form>
            <ul class="list-group">
                @foreach($sizeRanges as $sizeRange)
                <li class="list-group-item" id="size-range-item-{{ $sizeRange->id }}">
                    <div class="row align-items-center">
                        <div class="col-12 col-md-2 mb-2 bg-light p-1" id="size-range-display-{{ $sizeRange->id }}">
                            {{ $sizeRange->name }}
                        </div>
                        <div class="col-12 col-md-5 mb-2 d-none" id="size-range-edit-form-{{ $sizeRange->id }}">
                            <form action="{{ route('admin.size-ranges.update', $sizeRange->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="input-group">
                                    <input type="text" name="name" value="{{ $sizeRange->name }}" class="form-control bg-light" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-success btn-sm" type="submit"><i class="fas fa-edit"></i> Update</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="cancelEdit({{ $sizeRange->id }}, 'size-range')"><i class="fas fa-times"></i> Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-md-3 text-md-right">
                            <button class="btn btn-sm btn-primary mb-1" onclick="editItem({{ $sizeRange->id }}, 'size-range')">
                                <i class="fas fa-edit"></i> Update
                            </button>
                            <form action="{{ route('admin.size-ranges.destroy', $sizeRange->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger mb-1">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>
            <div class="d-flex justify-content-center mt-4">
                {{ $sizeRanges->links() }}
            </div>
        </div>

        <!-- Color Tab -->
        <div class="tab-pane fade" id="color-tab" role="tabpanel">
            <form action="{{ route('admin.colors.store') }}" method="POST" class="mb-3">
                @csrf
                <div class="row">
                    <div class="col-12 col-md-9 mb-2">
                        <label style="font-weight: 800;">Enter Color</label>
                        <input type="text" name="name" class="form-control bg-light" placeholder="Enter color" required>
                    </div>
                    <div class="col-12 col-md-3">
                        <button class="btn btn-primary w-100" style="margin-top: 33px;"><i class="fas fa-plus"></i> Add</button>
                    </div>
                </div>
            </form>
            <ul class="list-group">
                @foreach($colors as $color)
                <li class="list-group-item" id="color-item-{{ $color->id }}">
                    <div class="row align-items-center">
                        <div class="col-12 col-md-2 mb-2 bg-light p-1" id="color-display-{{ $color->id }}">
                            {{ $color->name }}
                        </div>
                        <div class="col-12 col-md-5 mb-2 d-none" id="color-edit-form-{{ $color->id }}">
                            <form action="{{ route('admin.colors.update', $color->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="input-group">
                                    <input type="text" name="name" value="{{ $color->name }}" class="form-control bg-light" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-success btn-sm" type="submit"><i class="fas fa-edit"></i> Update</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="cancelEdit({{ $color->id }}, 'color')"><i class="fas fa-times"></i> Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-md-3 text-md-right">
                            <button class="btn btn-sm btn-primary mb-1" onclick="editItem({{ $color->id }}, 'color')">
                                <i class="fas fa-edit"></i> Update
                            </button>
                            <form action="{{ route('admin.colors.destroy', $color->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger mb-1">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>
            <div class="d-flex justify-content-center mt-4">
                {{ $colors->links() }}
            </div>
        </div>

        <!-- Fabric Composition Tab -->
        <div class="tab-pane fade" id="fabric-composition-tab" role="tabpanel">
            <form action="{{ route('admin.fabric-compositions.store') }}" method="POST" class="mb-3">
                @csrf
                <div class="row">
                    <div class="col-12 col-md-9 mb-2">
                        <label style="font-weight: 800;">Enter Fabric Composition</label>
                        <input type="text" name="name" class="form-control bg-light" placeholder="Enter fabric composition" required>
                    </div>
                    <div class="col-12 col-md-3">
                        <button class="btn btn-primary w-100" style="margin-top: 33px;"><i class="fas fa-plus"></i> Add</button>
                    </div>
                </div>
            </form>
            <ul class="list-group">
                @foreach($fabricCompositions as $fabricComposition)
                <li class="list-group-item" id="fabric-composition-item-{{ $fabricComposition->id }}">
                    <div class="row align-items-center">
                        <div class="col-12 col-md-2 mb-2 bg-light p-1" id="fabric-composition-display-{{ $fabricComposition->id }}">
                            {{ $fabricComposition->name }}
                        </div>
                        <div class="col-12 col-md-5 mb-2 d-none" id="fabric-composition-edit-form-{{ $fabricComposition->id }}">
                            <form action="{{ route('admin.fabric-compositions.update', $fabricComposition->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="input-group">
                                    <input type="text" name="name" value="{{ $fabricComposition->name }}" class="form-control bg-light" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-success btn-sm" type="submit"><i class="fas fa-edit"></i> Update</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="cancelEdit({{ $fabricComposition->id }}, 'fabric-composition')"><i class="fas fa-times"></i> Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-md-3 text-md-right">
                            <button class="btn btn-sm btn-primary mb-1" onclick="editItem({{ $fabricComposition->id }}, 'fabric-composition')">
                                <i class="fas fa-edit"></i> Update
                            </button>
                            <form action="{{ route('admin.fabric-compositions.destroy', $fabricComposition->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger mb-1">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>
            <div class="d-flex justify-content-center mt-4">
                {{ $fabricCompositions->links() }}
            </div>
        </div>

        <!-- Fabric Type Tab -->
        <div class="tab-pane fade" id="fabric-type-tab" role="tabpanel">
            <form action="{{ route('admin.fabric-types.store') }}" method="POST" class="mb-3">
                @csrf
                <div class="row">
                    <div class="col-12 col-md-9 mb-2">
                        <label style="font-weight: 800;">Enter Fabric Type</label>
                        <input type="text" name="name" class="form-control bg-light" placeholder="Enter fabric type" required>
                    </div>
                    <div class="col-12 col-md-3">
                        <button class="btn btn-primary w-100" style="margin-top: 33px;"><i class="fas fa-plus"></i> Add</button>
                    </div>
                </div>
            </form>
            <ul class="list-group">
                @foreach($fabricTypes as $fabricType)
                <li class="list-group-item" id="fabric-type-item-{{ $fabricType->id }}">
                    <div class="row align-items-center">
                        <div class="col-12 col-md-2 mb-2 bg-light p-1" id="fabric-type-display-{{ $fabricType->id }}">
                            {{ $fabricType->name }}
                        </div>
                        <div class="col-12 col-md-5 mb-2 d-none" id="fabric-type-edit-form-{{ $fabricType->id }}">
                            <form action="{{ route('admin.fabric-types.update', $fabricType->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="input-group">
                                    <input type="text" name="name" value="{{ $fabricType->name }}" class="form-control bg-light" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-success btn-sm" type="submit"><i class="fas fa-edit"></i> Update</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="cancelEdit({{ $fabricType->id }}, 'fabric-type')"><i class="fas fa-times"></i> Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-md-3 text-md-right">
                            <button class="btn btn-sm btn-primary mb-1" onclick="editItem({{ $fabricType->id }}, 'fabric-type')">
                                <i class="fas fa-edit"></i> Update
                            </button>
                            <form action="{{ route('admin.fabric-types.destroy', $fabricType->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger mb-1">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>
            <div class="d-flex justify-content-center mt-4">
                {{ $fabricTypes->links() }}
            </div>
        </div>

        <!-- Yarn Count Tab -->
        <div class="tab-pane fade" id="yarn-count-tab" role="tabpanel">
            <form action="{{ route('admin.yarn-counts.store') }}" method="POST" class="mb-3">
                @csrf
                <div class="row">
                    <div class="col-12 col-md-9 mb-2">
                        <label style="font-weight: 800;">Enter Yarn Count</label>
                        <input type="text" name="name" class="form-control bg-light" placeholder="Enter yarn count" required>
                    </div>
                    <div class="col-12 col-md-3">
                        <button class="btn btn-primary w-100" style="margin-top: 33px;"><i class="fas fa-plus"></i> Add</button>
                    </div>
                </div>
            </form>
            <ul class="list-group">
                @foreach($yarnCounts as $yarnCount)
                <li class="list-group-item" id="yarn-count-item-{{ $yarnCount->id }}">
                    <div class="row align-items-center">
                        <div class="col-12 col-md-2 mb-2 bg-light p-1" id="yarn-count-display-{{ $yarnCount->id }}">
                            {{ $yarnCount->name }}
                        </div>
                        <div class="col-12 col-md-5 mb-2 d-none" id="yarn-count-edit-form-{{ $yarnCount->id }}">
                            <form action="{{ route('admin.yarn-counts.update', $yarnCount->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="input-group">
                                    <input type="text" name="name" value="{{ $yarnCount->name }}" class="form-control bg-light" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-success btn-sm" type="submit"><i class="fas fa-edit"></i> Update</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="cancelEdit({{ $yarnCount->id }}, 'yarn-count')"><i class="fas fa-times"></i> Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-md-3 text-md-right">
                            <button class="btn btn-sm btn-primary mb-1" onclick="editItem({{ $yarnCount->id }}, 'yarn-count')">
                                <i class="fas fa-edit"></i> Update
                            </button>
                            <form action="{{ route('admin.yarn-counts.destroy', $yarnCount->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger mb-1">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>
            <div class="d-flex justify-content-center mt-4">
                {{ $yarnCounts->links() }}
            </div>
        </div>

        <!-- Fabric Weight/GSM Tab -->
        <div class="tab-pane fade" id="fabric-weight-tab" role="tabpanel">
            <form action="{{ route('admin.fabric-weights.store') }}" method="POST" class="mb-3">
                @csrf
                <div class="row">
                    <div class="col-12 col-md-9 mb-2">
                        <label style="font-weight: 800;">Enter Fabric Weight/GSM</label>
                        <input type="text" name="name" class="form-control bg-light" placeholder="Enter fabric weight/gsm" required>
                    </div>
                    <div class="col-12 col-md-3">
                        <button class="btn btn-primary w-100" style="margin-top: 33px;"><i class="fas fa-plus"></i> Add</button>
                    </div>
                </div>
            </form>
            <ul class="list-group">
                @foreach($fabricWeights as $fabricWeight)
                <li class="list-group-item" id="fabric-weight-item-{{ $fabricWeight->id }}">
                    <div class="row align-items-center">
                        <div class="col-12 col-md-2 mb-2 bg-light p-1" id="fabric-weight-display-{{ $fabricWeight->id }}">
                            {{ $fabricWeight->name }}
                        </div>
                        <div class="col-12 col-md-5 mb-2 d-none" id="fabric-weight-edit-form-{{ $fabricWeight->id }}">
                            <form action="{{ route('admin.fabric-weights.update', $fabricWeight->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="input-group">
                                    <input type="text" name="name" value="{{ $fabricWeight->name }}" class="form-control bg-light" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-success btn-sm" type="submit"><i class="fas fa-edit"></i> Update</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="cancelEdit({{ $fabricWeight->id }}, 'fabric-weight')"><i class="fas fa-times"></i> Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-md-3 text-md-right">
                            <button class="btn btn-sm btn-primary mb-1" onclick="editItem({{ $fabricWeight->id }}, 'fabric-weight')">
                                <i class="fas fa-edit"></i> Update
                            </button>
                            <form action="{{ route('admin.fabric-weights.destroy', $fabricWeight->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger mb-1">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>
            <div class="d-flex justify-content-center mt-4">
                {{ $fabricWeights->links() }}
            </div>
        </div>

        <!-- Port of Landing Tab -->
        <div class="tab-pane fade" id="port-of-landing-tab" role="tabpanel">
            <form action="{{ route('admin.port-of-landings.store') }}" method="POST" class="mb-3">
                @csrf
                <div class="row">
                    <div class="col-12 col-md-9 mb-2">
                        <label style="font-weight: 800;">Enter Port of Landing</label>
                        <input type="text" name="name" class="form-control bg-light" placeholder="Enter port of landing" required>
                    </div>
                    <div class="col-12 col-md-3">
                        <button class="btn btn-primary w-100" style="margin-top: 33px;"><i class="fas fa-plus"></i> Add</button>
                    </div>
                </div>
            </form>
            <ul class="list-group">
                @foreach($portOfLandings as $portOfLanding)
                <li class="list-group-item" id="port-of-landing-item-{{ $portOfLanding->id }}">
                    <div class="row align-items-center">
                        <div class="col-12 col-md-2 mb-2 bg-light p-1" id="port-of-landing-display-{{ $portOfLanding->id }}">
                            {{ $portOfLanding->name }}
                        </div>
                        <div class="col-12 col-md-5 mb-2 d-none" id="port-of-landing-edit-form-{{ $portOfLanding->id }}">
                            <form action="{{ route('admin.port-of-landings.update', $portOfLanding->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="input-group">
                                    <input type="text" name="name" value="{{ $portOfLanding->name }}" class="form-control bg-light" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-success btn-sm" type="submit"><i class="fas fa-edit"></i> Update</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="cancelEdit({{ $portOfLanding->id }}, 'port-of-landing')"><i class="fas fa-times"></i> Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-md-3 text-md-right">
                            <button class="btn btn-sm btn-primary mb-1" onclick="editItem({{ $portOfLanding->id }}, 'port-of-landing')">
                                <i class="fas fa-edit"></i> Update
                            </button>
                            <form action="{{ route('admin.port-of-landings.destroy', $portOfLanding->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger mb-1">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>
            <div class="d-flex justify-content-center mt-4">
                {{ $portOfLandings->links() }}
            </div>
        </div>

        <!-- Country of Origin Tab -->
        <div class="tab-pane fade" id="country-of-origin-tab" role="tabpanel">
            <form action="{{ route('admin.country-of-origins.store') }}" method="POST" class="mb-3">
                @csrf
                <div class="row">
                    <div class="col-12 col-md-9 mb-2">
                        <label style="font-weight: 800;">Enter Country of Origin</label>
                        <input type="text" name="name" class="form-control bg-light" placeholder="Enter country of origin" required>
                    </div>
                    <div class="col-12 col-md-3">
                        <button class="btn btn-primary w-100" style="margin-top: 33px;"><i class="fas fa-plus"></i> Add</button>
                    </div>
                </div>
            </form>
            <ul class="list-group">
                @foreach($countryOfOrigins as $countryOfOrigin)
                <li class="list-group-item" id="country-of-origin-item-{{ $countryOfOrigin->id }}">
                    <div class="row align-items-center">
                        <div class="col-12 col-md-2 mb-2 bg-light p-1" id="country-of-origin-display-{{ $countryOfOrigin->id }}">
                            {{ $countryOfOrigin->name }}
                        </div>
                        <div class="col-12 col-md-5 mb-2 d-none" id="country-of-origin-edit-form-{{ $countryOfOrigin->id }}">
                            <form action="{{ route('admin.country-of-origins.update', $countryOfOrigin->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="input-group">
                                    <input type="text" name="name" value="{{ $countryOfOrigin->name }}" class="form-control bg-light" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-success btn-sm" type="submit"><i class="fas fa-edit"></i> Update</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="cancelEdit({{ $countryOfOrigin->id }}, 'country-of-origin')"><i class="fas fa-times"></i> Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-md-3 text-md-right">
                            <button class="btn btn-sm btn-primary mb-1" onclick="editItem({{ $countryOfOrigin->id }}, 'country-of-origin')">
                                <i class="fas fa-edit"></i> Update
                            </button>
                            <form action="{{ route('admin.country-of-origins.destroy', $countryOfOrigin->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger mb-1">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>
            <div class="d-flex justify-content-center mt-4">
                {{ $countryOfOrigins->links() }}
            </div>
        </div>

        <!-- Port of Discharge Tab -->
        <div class="tab-pane fade" id="port-of-discharge-tab" role="tabpanel">
            <form action="{{ route('admin.port-of-discharges.store') }}" method="POST" class="mb-3">
                @csrf
                <div class="row">
                    <div class="col-12 col-md-9 mb-2">
                        <label style="font-weight: 800;">Enter Port of Discharge</label>
                        <input type="text" name="name" class="form-control bg-light" placeholder="Enter port of discharge" required>
                    </div>
                    <div class="col-12 col-md-3">
                        <button class="btn btn-primary w-100" style="margin-top: 33px;"><i class="fas fa-plus"></i> Add</button>
                    </div>
                </div>
            </form>
            <ul class="list-group">
                @foreach($portOfDischarges as $portOfDischarge)
                <li class="list-group-item" id="port-of-discharge-item-{{ $portOfDischarge->id }}">
                    <div class="row align-items-center">
                        <div class="col-12 col-md-2 mb-2 bg-light p-1" id="port-of-discharge-display-{{ $portOfDischarge->id }}">
                            {{ $portOfDischarge->name }}
                        </div>
                        <div class="col-12 col-md-5 mb-2 d-none" id="port-of-discharge-edit-form-{{ $portOfDischarge->id }}">
                            <form action="{{ route('admin.port-of-discharges.update', $portOfDischarge->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="input-group">
                                    <input type="text" name="name" value="{{ $portOfDischarge->name }}" class="form-control bg-light" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-success btn-sm" type="submit"><i class="fas fa-edit"></i> Update</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="cancelEdit({{ $portOfDischarge->id }}, 'port-of-discharge')"><i class="fas fa-times"></i> Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-md-3 text-md-right">
                            <button class="btn btn-sm btn-primary mb-1" onclick="editItem({{ $portOfDischarge->id }}, 'port-of-discharge')">
                                <i class="fas fa-edit"></i> Update
                            </button>
                            <form action="{{ route('admin.port-of-discharges.destroy', $portOfDischarge->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger mb-1">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>
            <div class="d-flex justify-content-center mt-4">
                {{ $portOfDischarges->links() }}
            </div>
        </div>

        <!-- Final Destination Tab -->
        <div class="tab-pane fade" id="final-destination-tab" role="tabpanel">
            <form action="{{ route('admin.final-destinations.store') }}" method="POST" class="mb-3">
                @csrf
                <div class="row">
                    <div class="col-12 col-md-9 mb-2">
                        <label style="font-weight: 800;">Enter Final Destination</label>
                        <input type="text" name="name" class="form-control bg-light" placeholder="Enter final destination" required>
                    </div>
                    <div class="col-12 col-md-3">
                        <button class="btn btn-primary w-100" style="margin-top: 33px;"><i class="fas fa-plus"></i> Add</button>
                    </div>
                </div>
            </form>
            <ul class="list-group">
                @foreach($finalDestinations as $finalDestination)
                <li class="list-group-item" id="final-destination-item-{{ $finalDestination->id }}">
                    <div class="row align-items-center">
                        <div class="col-12 col-md-2 mb-2 bg-light p-1" id="final-destination-display-{{ $finalDestination->id }}">
                            {{ $finalDestination->name }}
                        </div>
                        <div class="col-12 col-md-5 mb-2 d-none" id="final-destination-edit-form-{{ $finalDestination->id }}">
                            <form action="{{ route('admin.final-destinations.update', $finalDestination->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="input-group">
                                    <input type="text" name="name" value="{{ $finalDestination->name }}" class="form-control bg-light" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-success btn-sm" type="submit"><i class="fas fa-edit"></i> Update</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="cancelEdit({{ $finalDestination->id }}, 'final-destination')"><i class="fas fa-times"></i> Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-md-3 text-md-right">
                            <button class="btn btn-sm btn-primary mb-1" onclick="editItem({{ $finalDestination->id }}, 'final-destination')">
                                <i class="fas fa-edit"></i> Update
                            </button>
                            <form action="{{ route('admin.final-destinations.destroy', $finalDestination->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger mb-1">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>
            <div class="d-flex justify-content-center mt-4">
                {{ $finalDestinations->links() }}
            </div>
        </div>

        <!-- Delivery Terms Tab -->
        <div class="tab-pane fade" id="delivery-term-tab" role="tabpanel">
            <form action="{{ route('admin.delivery-terms.store') }}" method="POST" class="mb-3">
                @csrf
                <div class="row">
                    <div class="col-12 col-md-9 mb-2">
                        <label style="font-weight: 800;">Enter Delivery Term</label>
                        <input type="text" name="name" class="form-control bg-light" placeholder="Enter delivery term" required>
                    </div>
                    <div class="col-12 col-md-3">
                        <button class="btn btn-primary w-100" style="margin-top: 33px;"><i class="fas fa-plus"></i> Add</button>
                    </div>
                </div>
            </form>
            <ul class="list-group">
                @foreach($deliveryTerms as $deliveryTerm)
                <li class="list-group-item" id="delivery-term-item-{{ $deliveryTerm->id }}">
                    <div class="row align-items-center">
                        <div class="col-12 col-md-2 mb-2 bg-light p-1" id="delivery-term-display-{{ $deliveryTerm->id }}">
                            {{ $deliveryTerm->name }}
                        </div>
                        <div class="col-12 col-md-5 mb-2 d-none" id="delivery-term-edit-form-{{ $deliveryTerm->id }}">
                            <form action="{{ route('admin.delivery-terms.update', $deliveryTerm->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="input-group">
                                    <input type="text" name="name" value="{{ $deliveryTerm->name }}" class="form-control bg-light" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-success btn-sm" type="submit"><i class="fas fa-edit"></i> Update</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="cancelEdit({{ $deliveryTerm->id }}, 'delivery-term')"><i class="fas fa-times"></i> Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-md-3 text-md-right">
                            <button class="btn btn-sm btn-primary mb-1" onclick="editItem({{ $deliveryTerm->id }}, 'delivery-term')">
                                <i class="fas fa-edit"></i> Update
                            </button>
                            <form action="{{ route('admin.delivery-terms.destroy', $deliveryTerm->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger mb-1">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>
            <div class="d-flex justify-content-center mt-4">
                {{ $deliveryTerms->links() }}
            </div>
        </div>

        <!-- Shipment Mode Tab -->
        <div class="tab-pane fade" id="shipment-mode-tab" role="tabpanel">
            <form action="{{ route('admin.shipment-modes.store') }}" method="POST" class="mb-3">
                @csrf
                <div class="row">
                    <div class="col-12 col-md-9 mb-2">
                        <label style="font-weight: 800;">Enter Shipment Mode</label>
                        <input type="text" name="name" class="form-control bg-light" placeholder="Enter shipment mode" required>
                    </div>
                    <div class="col-12 col-md-3">
                        <button class="btn btn-primary w-100" style="margin-top: 33px;"><i class="fas fa-plus"></i> Add</button>
                    </div>
                </div>
            </form>
            <ul class="list-group">
                @foreach($shipmentModes as $shipmentMode)
                <li class="list-group-item" id="shipment-mode-item-{{ $shipmentMode->id }}">
                    <div class="row align-items-center">
                        <div class="col-12 col-md-2 mb-2 bg-light p-1" id="shipment-mode-display-{{ $shipmentMode->id }}">
                            {{ $shipmentMode->name }}
                        </div>
                        <div class="col-12 col-md-5 mb-2 d-none" id="shipment-mode-edit-form-{{ $shipmentMode->id }}">
                            <form action="{{ route('admin.shipment-modes.update', $shipmentMode->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="input-group">
                                    <input type="text" name="name" value="{{ $shipmentMode->name }}" class="form-control bg-light" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-success btn-sm" type="submit"><i class="fas fa-edit"></i> Update</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="cancelEdit({{ $shipmentMode->id }}, 'shipment-mode')"><i class="fas fa-times"></i> Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-md-3 text-md-right">
                            <button class="btn btn-sm btn-primary mb-1" onclick="editItem({{ $shipmentMode->id }}, 'shipment-mode')">
                                <i class="fas fa-edit"></i> Update
                            </button>
                            <form action="{{ route('admin.shipment-modes.destroy', $shipmentMode->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger mb-1">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>
            <div class="d-flex justify-content-center mt-4">
                {{ $shipmentModes->links() }}
            </div>
        </div>

        <!-- Payment Terms Tab -->
        <div class="tab-pane fade" id="payment-term-tab" role="tabpanel">
            <form action="{{ route('admin.payment-terms.store') }}" method="POST" class="mb-3">
                @csrf
                <div class="row">
                    <div class="col-12 col-md-9 mb-2">
                        <label style="font-weight: 800;">Enter Payment Term</label>
                        <input type="text" name="name" class="form-control bg-light" placeholder="Enter payment term" required>
                    </div>
                    <div class="col-12 col-md-3">
                        <button class="btn btn-primary w-100" style="margin-top: 33px;"><i class="fas fa-plus"></i> Add</button>
                    </div>
                </div>
            </form>
            <ul class="list-group">
                @foreach($paymentTerms as $paymentTerm)
                <li class="list-group-item" id="payment-term-item-{{ $paymentTerm->id }}">
                    <div class="row align-items-center">
                        <div class="col-12 col-md-2 mb-2 bg-light p-1" id="payment-term-display-{{ $paymentTerm->id }}">
                            {{ $paymentTerm->name }}
                        </div>
                        <div class="col-12 col-md-5 mb-2 d-none" id="payment-term-edit-form-{{ $paymentTerm->id }}">
                            <form action="{{ route('admin.payment-terms.update', $paymentTerm->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="input-group">
                                    <input type="text" name="name" value="{{ $paymentTerm->name }}" class="form-control bg-light" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-success btn-sm" type="submit"><i class="fas fa-edit"></i> Update</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="cancelEdit({{ $paymentTerm->id }}, 'payment-term')"><i class="fas fa-times"></i> Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-md-3 text-md-right">
                            <button class="btn btn-sm btn-primary mb-1" onclick="editItem({{ $paymentTerm->id }}, 'payment-term')">
                                <i class="fas fa-edit"></i> Update
                            </button>
                            <form action="{{ route('admin.payment-terms.destroy', $paymentTerm->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger mb-1">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>
            <div class="d-flex justify-content-center mt-4">
                {{ $paymentTerms->links() }}
            </div>
        </div>

        <!-- Payment Mode Tab -->
        <div class="tab-pane fade" id="payment-mode-tab" role="tabpanel">
            <form action="{{ route('admin.payment-modes.store') }}" method="POST" class="mb-3">
                @csrf
                <div class="row">
                    <div class="col-12 col-md-9 mb-2">
                        <label style="font-weight: 800;">Enter Payment Mode</label>
                        <input type="text" name="name" class="form-control bg-light" placeholder="Enter payment mode" required>
                    </div>
                    <div class="col-12 col-md-3">
                        <button class="btn btn-primary w-100" style="margin-top: 33px;"><i class="fas fa-plus"></i> Add</button>
                    </div>
                </div>
            </form>
            <ul class="list-group">
                @foreach($paymentModes as $paymentMode)
                <li class="list-group-item" id="payment-mode-item-{{ $paymentMode->id }}">
                    <div class="row align-items-center">
                        <div class="col-12 col-md-2 mb-2 bg-light p-1" id="payment-mode-display-{{ $paymentMode->id }}">
                            {{ $paymentMode->name }}
                        </div>
                        <div class="col-12 col-md-5 mb-2 d-none" id="payment-mode-edit-form-{{ $paymentMode->id }}">
                            <form action="{{ route('admin.payment-modes.update', $paymentMode->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="input-group">
                                    <input type="text" name="name" value="{{ $paymentMode->name }}" class="form-control bg-light" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-success btn-sm" type="submit"><i class="fas fa-edit"></i> Update</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="cancelEdit({{ $paymentMode->id }}, 'payment-mode')"><i class="fas fa-times"></i> Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-md-3 text-md-right">
                            <button class="btn btn-sm btn-primary mb-1" onclick="editItem({{ $paymentMode->id }}, 'payment-mode')">
                                <i class="fas fa-edit"></i> Update
                            </button>
                            <form action="{{ route('admin.payment-modes.destroy', $paymentMode->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger mb-1">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>
            <div class="d-flex justify-content-center mt-4">
                {{ $paymentModes->links() }}
            </div>
        </div>

    </div>
</div>

<script>
// Success message code
document.addEventListener("DOMContentLoaded", function () {
    @if (session('success'))
        Swal.fire({
            title: 'Success!',
            text: '{{ session("success") }}',
            icon: 'success',
            confirmButtonText: 'OK'
        });
    @endif
});

function editItem(id, typePrefix) {
    const displayDiv = document.getElementById(typePrefix + '-display-' + id);
    const editForm = document.getElementById(typePrefix + '-edit-form-' + id);

    if (displayDiv && editForm) {
        displayDiv.style.display = 'none';
        editForm.classList.remove('d-none');
    }
}

function cancelEdit(id, typePrefix) {
    const displayDiv = document.getElementById(typePrefix + '-display-' + id);
    const editForm = document.getElementById(typePrefix + '-edit-form-' + id);

    if (displayDiv && editForm) {
        displayDiv.style.display = 'block'; // Or 'flex' or whatever its original display was, block is common for divs
        editForm.classList.add('d-none');
    }
}
</script>

@include('admin.footer')
