@include('admin.header')

<div class="container">
    <h4 class="mb-3">Factory List</h4>
    <a href="{{ route('admin.factories.create') }}" class="btn btn-primary mb-3" style="float: right;"><i class="fas fa-plus"></i> Add Factory</a>

       @if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="zmdi zmdi-check-circle"></i> {{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif

    <div class="table-responsive">
        <table class="table table-bordered table-striped" id="factoryTable">
            <thead class="thead-dark">
                <tr>
                    <th>Name</th>
                    <th>Location</th>
                    <th>Contact Person</th>
                    <th>Phone</th>
                    <th>Email</th>
                    <th>Compliance</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($factories as $factory)
                    <tr>
                        <td>{{ $factory->name }}</td>
                        <td>{{ $factory->location }}</td>
                        <td>{{ $factory->contact_person }}</td>
                        <td>{{ $factory->phone }}</td>
                        <td>{{ $factory->email }}</td>
                        <td>
                       @if(isset($factory->compliance_doc))
    <small>Current: <a href="{{ asset($factory->compliance_doc) }}" target="_blank">View File</a></small>
                            @else
                                N/A
                            @endif
                        </td>
                        <td>
<div class="dropdown">
    <button class="btn btn-primary btn-sm dropdown-toggle" type="button" id="buyerActionsDropdown" data-bs-toggle="dropdown" aria-expanded="false">
        Actions
    </button>
    <ul class="dropdown-menu" aria-labelledby="buyerActionsDropdown">
        <li>
           
                            <a href="{{ route('admin.factories.edit', $factory->id) }}" class="dropdown-item  "><i class="fas fa-edit"></i> Udpate</a>
        </li>
      
        <li>    
                            <form action="{{ route('admin.factories.destroy', $factory->id) }}" method="POST" style="display:inline-block;">
                                @csrf @method('DELETE')
                                <button class=" dropdown-item" onclick="return confirm('Delete?')"><i class="fas fa-trash"></i> Remove</button>
                            </form>

                    </li>
    </ul>
</div>


                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
<div class="d-flex justify-content-center mt-4">
    {{ $factories->links() }}
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>





@include('admin.footer')
