<div class="container mt-4">
    <h2 class="mb-4">
        <i class="fas fa-industry"></i> {{ isset($factory) ? 'Update' : 'Add' }} Factory
    </h2>

    <form action="{{ isset($factory) ? route('admin.factories.update', $factory->id) : route('admin.factories.store') }}" method="POST" enctype="multipart/form-data" class="bg-white p-3">
        @csrf
        @if(isset($factory)) @method('PUT') @endif

        <div class="row">
            <div class="form-group col-md-6">
                <label>Factory Name *</label>
                <div class="input-group">
                    <div class="input-group-prepend"><span class="input-group-text"><i class="fas fa-industry"></i></span></div>
                    <input type="text" name="name" value="{{ old('name', $factory->name ?? '') }}" class="form-control" placeholder="Enter factory name" required>
                </div>
            </div>

            <div class="form-group col-md-6">
                <label>Location</label>
                <div class="input-group">
                    <div class="input-group-prepend"><span class="input-group-text"><i class="fas fa-map-marker-alt"></i></span></div>
                    <input type="text" name="location" value="{{ old('location', $factory->location ?? '') }}" class="form-control" placeholder="Enter location">
                </div>
            </div>

            <div class="form-group col-md-6">
                <label>Contact Person</label>
                <div class="input-group">
                    <div class="input-group-prepend"><span class="input-group-text"><i class="fas fa-user"></i></span></div>
                    <input type="text" name="contact_person" value="{{ old('contact_person', $factory->contact_person ?? '') }}" class="form-control" placeholder="Enter contact person">
                </div>
            </div>

            <div class="form-group col-md-6">
                <label>Email</label>
                <div class="input-group">
                    <div class="input-group-prepend"><span class="input-group-text"><i class="fas fa-envelope"></i></span></div>
                    <input type="email" name="email" value="{{ old('email', $factory->email ?? '') }}" class="form-control" placeholder="Enter email address">
                </div>
            </div>

            <div class="form-group col-md-6">
                <label>Phone</label>
                <div class="input-group">
                    <div class="input-group-prepend"><span class="input-group-text"><i class="fas fa-phone"></i></span></div>
                    <input type="text" name="phone" value="{{ old('phone', $factory->phone ?? '') }}" class="form-control" placeholder="Enter phone number">
                </div>
            </div>

            <div class="form-group col-md-6">
                <label>Compliance Document</label>
                <div class="input-group">
                    <div class="input-group-prepend"><span class="input-group-text"><i class="fas fa-file-alt"></i></span></div>
                    <input type="file" name="compliance_doc" class="form-control">
                </div>
                @if(isset($factory->compliance_doc))
                    <small>Current: <a href="{{ asset('storage/' . $factory->compliance_doc) }}" target="_blank">View File</a></small>
                @endif
            </div>
        </div>

        <div class="mt-3">
            <button type="submit" class="btn btn-success">
                <i class="fas fa-save"></i> Save
            </button>
            <a href="{{ route('admin.factories.index') }}" class="btn btn-secondary">
                <i class="fas fa-times"></i> Cancel
            </a>
        </div>
    </form>
</div>
