<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Packing List - {{ $order->order_number ?? 'N/A' }}</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        .header { text-align: center; margin-bottom: 20px; }
        .section { margin-bottom: 15px; }
        .section-title { background: #f8f9fa; padding: 5px; font-weight: bold; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f8f9fa; }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
    </style>
</head>
<body>
    <div class="header">
        <h2>PACKING LIST</h2>
        <p>Order No: {{ $order->order_number ?? 'N/A' }}</p>
        <p>Date: {{ now()->format('M d, Y') }}</p>
    </div>

    <div class="section">
        <div class="section-title">Order Information</div>
        <table>
            <tr>
                <td width="25%"><strong>Order Number:</strong></td>
                <td>{{ $order->order_number ?? 'N/A' }}</td>
                <td width="25%"><strong>Customer PO:</strong></td>
                <td>{{ $order->customer_po_number ?? 'N/A' }}</td>
            </tr>
            <tr>
                <td><strong>Total Quantity:</strong></td>
                <td>{{ $order->confirmed_quantity ?? 'N/A' }} units</td>
                <td><strong>Delivery Date:</strong></td>
                <td>{{ $order->delivery_date ? $order->delivery_date->format('M d, Y') : 'N/A' }}</td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Packing Details</div>
        <table>
            <thead>
                <tr>
                    <th>Carton No</th>
                    <th>Description</th>
                    <th>Quantity</th>
                    <th>Weight (kg)</th>
                    <th>Dimensions (cm)</th>
                </tr>
            </thead>
            <tbody>
                @for($i = 1; $i <= 5; $i++)
                <tr>
                    <td class="text-center">{{ $i }}</td>
                    <td>Carton {{ $i }} - Order {{ $order->order_number ?? 'N/A' }}</td>
                    <td class="text-center">{{ floor($order->confirmed_quantity / 5) }}</td>
                    <td class="text-center">{{ rand(10, 25) }}</td>
                    <td class="text-center">40x30x30</td>
                </tr>
                @endfor
                <tr>
                    <td colspan="2" class="text-right"><strong>Total:</strong></td>
                    <td class="text-center"><strong>{{ $order->confirmed_quantity ?? 'N/A' }}</strong></td>
                    <td class="text-center"><strong>~{{ rand(80, 120) }} kg</strong></td>
                    <td></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Shipping Marks</div>
        <p>Order No: {{ $order->order_number ?? 'N/A' }}</p>
        <p>Carton No: 1-{{ ceil($order->confirmed_quantity / floor($order->confirmed_quantity / 5)) }}</p>
        <p>Made in: [Country of Origin]</p>
    </div>

    @if($include_terms)
    <div class="section">
        <div class="section-title">Packing Instructions</div>
        <p>1. All items must be properly packed to prevent damage during transit.<br>
           2. Each carton must be clearly marked with order number and carton number.<br>
           3. Fragile items must be marked accordingly.<br>
           4. Maximum weight per carton should not exceed 25kg.</p>
    </div>
    @endif
</body>
</html>