@include('admin.header')

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.document-generator.index') }}">Document Generator</a></li>
                        <li class="breadcrumb-item active">Templates</li>
                    </ol>
                </div>
                <h4 class="page-title">Document Templates</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-sm-6">
                            <h5 class="card-title">All Templates</h5>
                        </div>
                        <div class="col-sm-6 text-end">
                            <a href="{{ route('admin.document-templates.create') }}" class="btn btn-success">
                                <i class="fas fa-plus me-1"></i> Create Template
                            </a>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-centered table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Type</th>
                                    <th>Status</th>
                                    <th>Default</th>
                                    <th>Created By</th>
                                    <th>Created At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($templates as $template)
                                <tr>
                                    <td>
                                        <strong>{{ $template->name }}</strong>
                                    </td>
                                    <td>
                                        <span class="badge bg-info">{{ str_replace('_', ' ', ucfirst($template->type)) }}</span>
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $template->is_active ? 'success' : 'danger' }}">
                                            {{ $template->is_active ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($template->is_default)
                                            <span class="badge bg-primary">Default</span>
                                        @else
                                            <form action="{{ route('admin.document-templates.set-default', $template->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-sm btn-outline-primary" 
                                                        onclick="return confirm('Set this as default template?')">
                                                    Set Default
                                                </button>
                                            </form>
                                        @endif
                                    </td>
                                    <td>{{ $template->creator->name ?? 'System' }}</td>
                                    <td>{{ $template->created_at->format('M j, Y') }}</td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('admin.document-templates.edit', $template->id) }}" 
                                               class="btn btn-sm btn-outline-primary" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('admin.document-templates.destroy', $template->id) }}" 
                                                  method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger" 
                                                        onclick="return confirm('Delete this template?')" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center py-4">
                                        <div class="text-muted">
                                            <i class="fas fa-file-alt fa-3x mb-3"></i>
                                            <h5>No templates found</h5>
                                            <p>Create your first document template to get started.</p>
                                            <a href="{{ route('admin.document-templates.create') }}" class="btn btn-success">
                                                <i class="fas fa-plus me-1"></i> Create Template
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    @if($templates->hasPages())
                    <div class="row mt-3">
                        <div class="col-12">
                            {{ $templates->links() }}
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.footer')