@include('admin.header')

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.document-templates.index') }}">Templates</a></li>
                        <li class="breadcrumb-item active">Create Template</li>
                    </ol>
                </div>
                <a href="{{ route('admin.document-templates.index') }}" class="btn btn-success">Document List</a>
                <h4 class="page-title">Create New Template</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('admin.document-templates.store') }}" method="POST">
                        @csrf

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label">Template Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                           id="name" name="name" value="{{ old('name') }}" 
                                           placeholder="Enter template name" required>
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="type" class="form-label">Document Type <span class="text-danger">*</span></label>
                                    <select class="form-select @error('type') is-invalid @enderror" 
                                            id="type" name="type" required>
                                        <option value="">Select Document Type</option>
                                        <option value="commercial_invoice" {{ old('type') == 'commercial_invoice' ? 'selected' : '' }}>Commercial Invoice</option>
                                        <option value="packing_list" {{ old('type') == 'packing_list' ? 'selected' : '' }}>Packing List</option>
                                        <option value="certificate_origin" {{ old('type') == 'certificate_origin' ? 'selected' : '' }}>Certificate of Origin</option>
                                        <option value="bill_of_lading" {{ old('type') == 'bill_of_lading' ? 'selected' : '' }}>Bill of Lading</option>
                                        <option value="inspection_certificate" {{ old('type') == 'inspection_certificate' ? 'selected' : '' }}>Inspection Certificate</option>
                                        <option value="shipping_label" {{ old('type') == 'shipping_label' ? 'selected' : '' }}>Shipping Label</option>
                                    </select>
                                    @error('type')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="content" class="form-label">Template Content <span class="text-danger">*</span></label>
                                    <textarea class="form-control @error('content') is-invalid @enderror" 
                                              id="content" name="content" rows="15" 
                                              placeholder="Enter HTML template content with variables like {order_number}, {buyer_name}, etc." 
                                              required>{{ old('content') }}</textarea>
                                    @error('content')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">
                                        Use variables like: <code>{order_number}</code>, <code>{buyer_name}</code>, <code>{order_date}</code>, <code>{total_amount}</code>
                                    </small>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="variables" class="form-label">Available Variables (JSON)</label>
                                    <textarea class="form-control @error('variables') is-invalid @enderror" 
                                              id="variables" name="variables" rows="5"
                                              placeholder='{"order_number": "Order Number", "buyer_name": "Buyer Name" }'>{{ old('variables') }}</textarea>
                                    @error('variables')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">
                                        Define available variables in JSON format
                                    </small>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <div class="form-check form-switch mb-2">
                                        <input type="checkbox" class="form-check-input" 
                                               id="is_active" name="is_active" value="1" 
                                               {{ old('is_active', true) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_active">Active Template</label>
                                    </div>

                                    <div class="form-check form-switch">
                                        <input type="checkbox" class="form-check-input" 
                                               id="is_default" name="is_default" value="1"
                                               {{ old('is_default') ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_default">Set as Default Template</label>
                                    </div>

                                    <div class="mt-3">
                                        <small class="text-muted">
                                            <strong>Note:</strong> Setting as default will remove default status from other templates of the same type.
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-12">
                                <div class="d-flex justify-content-between">
                                    <a href="{{ route('admin.document-templates.index') }}" class="btn btn-secondary">
                                        <i class="fas fa-times me-1"></i> Cancel
                                    </a>
                                    <button type="submit" class="btn btn-success">
                                        <i class="fas fa-save me-1"></i> Create Template
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.footer')