<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Certificate of Origin - {{ $order->order_number ?? 'N/A' }}</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        .header { text-align: center; margin-bottom: 20px; border-bottom: 2px solid #000; padding-bottom: 10px; }
        .section { margin-bottom: 15px; }
        .section-title { background: #f8f9fa; padding: 5px; font-weight: bold; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f8f9fa; }
        .official-stamp { margin-top: 50px; text-align: center; }
    </style>
</head>
<body>
    <div class="header">
        <h2>CERTIFICATE OF ORIGIN</h2>
        <p><strong>Trade Document</strong></p>
    </div>

    <div class="section">
        <table>
            <tr>
                <td width="30%"><strong>Certificate No:</strong></td>
                <td>CO-{{ $order->order_number ?? 'N/A' }}-{{ date('Ymd') }}</td>
                <td width="30%"><strong>Date of Issue:</strong></td>
                <td>{{ now()->format('M d, Y') }}</td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Exporter Details</div>
        <table>
            <tr>
                <td width="25%"><strong>Name:</strong></td>
                <td>[Exporter Company Name]</td>
                <td width="25%"><strong>Address:</strong></td>
                <td>[Exporter Address]</td>
            </tr>
            <tr>
                <td><strong>Country:</strong></td>
                <td>[Exporting Country]</td>
                <td><strong>Tax ID:</strong></td>
                <td>[Exporter Tax ID]</td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Consignee Details</div>
        <table>
            <tr>
                <td width="25%"><strong>Name:</strong></td>
                <td>[Buyer Company Name]</td>
                <td width="25%"><strong>Address:</strong></td>
                <td>[Buyer Address]</td>
            </tr>
            <tr>
                <td><strong>Country:</strong></td>
                <td>[Destination Country]</td>
                <td><strong>Contact:</strong></td>
                <td>[Buyer Contact Info]</td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Goods Description</div>
        <table>
            <thead>
                <tr>
                    <th>Order No</th>
                    <th>Description of Goods</th>
                    <th>Quantity</th>
                    <th>Value (USD)</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ $order->order_number ?? 'N/A' }}</td>
                    <td>Commercial goods as per order confirmation</td>
                    <td>{{ $order->confirmed_quantity ?? 'N/A' }} units</td>
                    <td>${{ number_format($order->confirmed_quantity * $order->confirmed_price, 2) }}</td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Origin Criteria</div>
        <p>The undersigned hereby declares that the above mentioned goods originate in accordance with the rules of origin of the exporting country.</p>
        
        <p><strong>Origin Criterion:</strong> Wholly obtained or produced in [Country of Origin]</p>
    </div>

    <div class="section">
        <div class="section-title">Shipment Details</div>
        <table>
            <tr>
                <td width="25%"><strong>Port of Loading:</strong></td>
                <td>[Port of Loading]</td>
                <td width="25%"><strong>Port of Discharge:</strong></td>
                <td>[Port of Discharge]</td>
            </tr>
            <tr>
                <td><strong>Final Destination:</strong></td>
                <td>[Final Destination]</td>
                <td><strong>Transport Mode:</strong></td>
                <td>Sea Freight</td>
            </tr>
        </table>
    </div>

    @if($include_signature)
    <div class="official-stamp">
        <p>_________________________</p>
        <p><strong>Authorized Signature</strong></p>
        <p>Name: ___________________</p>
        <p>Position: ________________</p>
        <p>Date: {{ now()->format('M d, Y') }}</p>
        <br>
        <p><strong>OFFICIAL STAMP</strong></p>
        <div style="border: 2px solid #000; width: 150px; height: 150px; margin: 0 auto; display: flex; align-items: center; justify-content: center;">
            OFFICIAL<br>STAMP
        </div>
    </div>
    @endif
</body>
</html>