<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Bill of Lading - {{ $order->order_number ?? 'N/A' }}</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 11px; }
        .header { text-align: center; margin-bottom: 15px; border-bottom: 2px solid #000; padding-bottom: 10px; }
        .section { margin-bottom: 12px; }
        .section-title { background: #f8f9fa; padding: 4px; font-weight: bold; border: 1px solid #ddd; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 10px; }
        th, td { border: 1px solid #ddd; padding: 6px; text-align: left; }
        th { background-color: #f8f9fa; }
        .bordered-box { border: 1px solid #000; padding: 10px; margin-bottom: 10px; }
    </style>
</head>
<body>
    <div class="header">
        <h2>BILL OF LADING</h2>
        <p><strong>Non-Negotiable</strong></p>
    </div>

    <div class="section">
        <table>
            <tr>
                <td width="20%"><strong>B/L No:</strong></td>
                <td>BL-{{ $order->order_number ?? 'N/A' }}-{{ date('Ymd') }}</td>
                <td width="20%"><strong>Booking No:</strong></td>
                <td>BK-{{ $order->order_number ?? 'N/A' }}</td>
                <td width="20%"><strong>Date:</strong></td>
                <td>{{ now()->format('M d, Y') }}</td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="row" style="display: flex; margin-bottom: 10px;">
            <div class="bordered-box" style="flex: 1; margin-right: 10px;">
                <strong>SHIPPER/EXPORTER</strong><br>
                [Shipper Company Name]<br>
                [Shipper Address]<br>
                [Shipper City, Country]<br>
                Tel: [Shipper Phone]<br>
                Tax ID: [Shipper Tax ID]
            </div>
            <div class="bordered-box" style="flex: 1;">
                <strong>CONSIGNEE</strong><br>
                [Consignee Company Name]<br>
                [Consignee Address]<br>
                [Consignee City, Country]<br>
                Tel: [Consignee Phone]
            </div>
        </div>
    </div>

    <div class="section">
        <div class="bordered-box">
            <strong>NOTIFY PARTY</strong><br>
            [Notify Party Name]<br>
            [Notify Party Address]<br>
            [Notify Party City, Country]<br>
            Tel: [Notify Party Phone]
        </div>
    </div>

    <div class="section">
        <div class="section-title">VESSEL AND VOYAGE DETAILS</div>
        <table>
            <tr>
                <td width="25%"><strong>Vessel Name:</strong></td>
                <td>[Vessel Name]</td>
                <td width="25%"><strong>Voyage No:</strong></td>
                <td>[Voyage Number]</td>
            </tr>
            <tr>
                <td><strong>Port of Loading:</strong></td>
                <td>[Port of Loading]</td>
                <td><strong>Port of Discharge:</strong></td>
                <td>[Port of Discharge]</td>
            </tr>
            <tr>
                <td><strong>Final Destination:</strong></td>
                <td>[Final Destination]</td>
                <td><strong>Place of Receipt:</strong></td>
                <td>[Place of Receipt]</td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">CONTAINER AND GOODS DESCRIPTION</div>
        <table>
            <thead>
                <tr>
                    <th>Container No</th>
                    <th>Seal No</th>
                    <th>No of Packages</th>
                    <th>Description of Goods</th>
                    <th>Gross Weight (kg)</th>
                    <th>Measurement (cbm)</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>CONT{{ rand(100000, 999999) }}</td>
                    <td>SL{{ rand(10000, 99999) }}</td>
                    <td>{{ ceil($order->confirmed_quantity / 100) }}</td>
                    <td>COMMERCIAL GOODS - ORDER {{ $order->order_number ?? 'N/A' }}</td>
                    <td>{{ rand(10000, 25000) }}</td>
                    <td>{{ rand(20, 50) }}</td>
                </tr>
                <tr>
                    <td colspan="3"><strong>Total:</strong></td>
                    <td><strong>SHIPPER'S LOAD, COUNT & SEAL</strong></td>
                    <td><strong>{{ rand(10000, 25000) }} kg</strong></td>
                    <td><strong>{{ rand(20, 50) }} cbm</strong></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="section">
        <div class="section-title">MARKS AND NUMBERS</div>
        <div class="bordered-box">
            Order No: {{ $order->order_number ?? 'N/A' }}<br>
            Container No: AS ABOVE<br>
            Made in: [Country of Origin]<br>
            Gross Weight: AS ABOVE<br>
            Measurement: AS ABOVE
        </div>
    </div>

    <div class="section">
        <div class="section-title">FREIGHT AND CHARGES</div>
        <table>
            <tr>
                <td width="30%"><strong>Freight Payable at:</strong></td>
                <td>[Location]</td>
                <td width="30%"><strong>Freight Terms:</strong></td>
                <td>[Freight Terms]</td>
            </tr>
            <tr>
                <td><strong>Number of Originals:</strong></td>
                <td>THREE (3)</td>
                <td><strong>Place of Issue:</strong></td>
                <td>[Place of Issue]</td>
            </tr>
        </table>
    </div>

    <div style="margin-top: 50px;">
        <table>
            <tr>
                <td width="50%" style="border: none; padding: 20px;">
                    <strong>FOR CARRIER:</strong><br><br>
                    _________________________<br>
                    <strong>Authorized Signature</strong><br>
                    Date: ___________________
                </td>
                <td width="50%" style="border: none; padding: 20px;">
                    <strong>SHIPPED ON BOARD DATE:</strong><br><br>
                    _________________________<br>
                    <strong>Date and Time</strong><br>
                    Vessel: _________________
                </td>
            </tr>
        </table>
    </div>
</body>
</html>