@include('admin.header')

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.document-generator.index') }}">Document Generator</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.email-logs.index') }}">Email Logs</a></li>
                        <li class="breadcrumb-item active">Email Details</li>
                    </ol>
                </div>
                <h4 class="page-title">Email Details</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-sm-6">
                            <h5 class="card-title">Email Information</h5>
                        </div>
                        <div class="col-sm-6 text-end">
                            <a href="{{ route('admin.email-logs.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left me-1"></i> Back to List
                            </a>
                            @if($emailLog->status !== 'sent')
                            <form action="{{ route('admin.email-logs.resend', $emailLog->id) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-success" onclick="return confirm('Resend this email?')">
                                    <i class="fas fa-paper-plane me-1"></i> Resend
                                </button>
                            </form>
                            @endif
                        </div>
                    </div>

                    <div class="row">
                        <!-- Basic Information -->
                        <div class="col-md-6">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="card-title mb-0">Basic Information</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-sm table-borderless">
                                        <tr>
                                            <td width="30%"><strong>Email ID:</strong></td>
                                            <td>{{ $emailLog->id }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Status:</strong></td>
                                            <td>
                                                <span class="badge bg-{{ $emailLog->status === 'sent' ? 'success' : ($emailLog->status === 'failed' ? 'danger' : 'warning') }}">
                                                    {{ ucfirst($emailLog->status) }}
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><strong>Sent At:</strong></td>
                                            <td>
                                                @if($emailLog->sent_at)
                                                    {{ $emailLog->sent_at->format('M j, Y H:i') }}
                                                @else
                                                    <span class="text-muted">Not Sent</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><strong>Sender:</strong></td>
                                            <td>{{ $emailLog->sender->name ?? 'System' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Recipient Information -->
                        <div class="col-md-6">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="card-title mb-0">Recipient Information</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-sm table-borderless">
                                        <tr>
                                            <td width="30%"><strong>Recipient Name:</strong></td>
                                            <td>{{ $emailLog->recipient_name ?? 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Email Address:</strong></td>
                                            <td>{{ $emailLog->recipient_email }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Document:</strong></td>
                                            <td>
                                                @if($emailLog->document)
                                                    {{ $emailLog->document->document_type }} - 
                                                    {{ $emailLog->document->orderConfirmation->order_number ?? 'N/A' }}
                                                @else
                                                    <span class="text-muted">Document Deleted</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Email Content -->
                    <div class="row mt-3">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h6 class="card-title mb-0">Email Content</h6>
                                </div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <strong>Subject:</strong>
                                        <p class="mb-1">{{ $emailLog->subject }}</p>
                                    </div>
                                    
                                    <div>
                                        <strong>Message:</strong>
                                        <div class="border p-3 bg-white rounded">
                                            {!! nl2br(e($emailLog->message)) ?? '<span class="text-muted">No message content</span>' !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Document Preview -->
                    @if($emailLog->document && Storage::disk('public')->exists($emailLog->document->file_path))
                    <div class="row mt-3">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h6 class="card-title mb-0">Attached Document</h6>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <i class="fas fa-file-pdf text-danger me-2"></i>
                                            <span>{{ $emailLog->document->file_name }}</span>
                                            <small class="text-muted ms-2">
                                                ({{ number_format($emailLog->document->file_size / 1024, 2) }} KB)
                                            </small>
                                        </div>
                                        <a href="{{ route('admin.document-generator.generated-documents.download', $emailLog->document->id) }}" 
                                           class="btn btn-sm btn-primary" target="_blank">
                                            <i class="fas fa-download me-1"></i> Download
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.footer')