@include('admin.header')

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.document-generator.index') }}">Document Generator</a></li>
                        <li class="breadcrumb-item active">Email Logs</li>
                    </ol>
                </div>
                <h4 class="page-title">Email Logs</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-sm-12 col-md-6">
                            <h5 class="card-title">Email History</h5>
                        </div>
                        <div class="col-sm-12 col-md-6 text-end">
                            <div class="d-flex justify-content-end gap-2">
                                <button class="btn btn-outline-secondary" id="filter-toggle">
                                    <i class="fas fa-filter me-1"></i> Filters
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Filters -->
                    <div class="row mb-3" id="filter-section" style="display: none;">
                        <div class="col-12">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <form method="GET" class="row g-3">
                                        <div class="col-md-3">
                                            <label for="status" class="form-label">Status</label>
                                            <select name="status" id="status" class="form-select">
                                                <option value="">All Status</option>
                                                <option value="sent" {{ request('status') == 'sent' ? 'selected' : '' }}>Sent</option>
                                                <option value="failed" {{ request('status') == 'failed' ? 'selected' : '' }}>Failed</option>
                                                <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <label for="start_date" class="form-label">Start Date</label>
                                            <input type="date" name="start_date" id="start_date" class="form-control" value="{{ request('start_date') }}">
                                        </div>
                                        <div class="col-md-3">
                                            <label for="end_date" class="form-label">End Date</label>
                                            <input type="date" name="end_date" id="end_date" class="form-control" value="{{ request('end_date') }}">
                                        </div>
                                        <div class="col-md-3">
                                            <label class="form-label">&nbsp;</label>
                                            <div class="d-grid">
                                                <button type="submit" class="btn btn-primary">Apply</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Email Logs Table -->
                    <div class="table-responsive">
                        <table class="table table-centered table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Recipient</th>
                                    <th>Document</th>
                                    <th>Subject</th>
                                    <th>Status</th>
                                    <th>Sent At</th>
                                    <th>Sender</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($emailLogs as $log)
                                <tr>
                                    <td>{{ $log->id }}</td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="flex-shrink-0">
                                                <i class="fas fa-envelope text-primary"></i>
                                            </div>
                                            <div class="flex-grow-1 ms-2">
                                                <strong>{{ $log->recipient_name ?? 'N/A' }}</strong>
                                                <br>
                                                <small class="text-muted">{{ $log->recipient_email }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        @if($log->document)
                                            {{ $log->document->document_type }} - {{ $log->document->orderConfirmation->order_number ?? 'N/A' }}
                                        @else
                                            <span class="text-muted">Document Deleted</span>
                                        @endif
                                    </td>
                                    <td>{{ Str::limit($log->subject, 50) }}</td>
                                    <td>
                                        <span class="badge bg-{{ $log->status === 'sent' ? 'success' : ($log->status === 'failed' ? 'danger' : 'warning') }}">
                                            {{ ucfirst($log->status) }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($log->sent_at)
                                            {{ $log->sent_at->format('M j, Y H:i') }}
                                        @else
                                            <span class="text-muted">Not Sent</span>
                                        @endif
                                    </td>
                                    <td>{{ $log->sender->name ?? 'System' }}</td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('admin.email-logs.show', $log->id) }}" 
                                               class="btn btn-sm btn-outline-primary" 
                                               title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @if($log->status !== 'sent')
                                            <form action="{{ route('admin.email-logs.resend', $log->id) }}" 
                                                  method="POST" 
                                                  class="d-inline">
                                                @csrf
                                                <button type="submit" 
                                                        class="btn btn-sm btn-outline-success" 
                                                        title="Resend Email"
                                                        onclick="return confirm('Are you sure you want to resend this email?')">
                                                    <i class="fas fa-paper-plane"></i>
                                                </button>
                                            </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center py-4">
                                        <div class="text-muted">
                                            <i class="fas fa-inbox fa-3x mb-3"></i>
                                            <h5>No email logs found</h5>
                                            <p>No emails have been sent yet.</p>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if($emailLogs->hasPages())
                    <div class="row mt-3">
                        <div class="col-12">
                            {{ $emailLogs->links() }}
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle filter section
    document.getElementById('filter-toggle').addEventListener('click', function() {
        const filterSection = document.getElementById('filter-section');
        if (filterSection.style.display === 'none') {
            filterSection.style.display = 'block';
            this.innerHTML = '<i class="fas fa-times me-1"></i> Hide Filters';
        } else {
            filterSection.style.display = 'none';
            this.innerHTML = '<i class="fas fa-filter me-1"></i> Filters';
        }
    });

    // Auto-hide filters after form submission
    @if(request()->hasAny(['status', 'start_date', 'end_date']))
        document.getElementById('filter-section').style.display = 'block';
        document.getElementById('filter-toggle').innerHTML = '<i class="fas fa-times me-1"></i> Hide Filters';
    @endif
});
</script>

@include('admin.footer')