@include('admin.header')
        <div class="main-panel">
          <div class="content-wrapper">
            <div class="row">
            
 <div class="container mt-4">
    <h2>Blog Categories</h2>
    <a href="{{ route('admin.categories.create') }}" class="btn btn-primary mb-3">Add New Category</a>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <table class="table  table-striped " id="blogsTable">
        <thead>
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($categories as $key => $category)
                <tr>
                    <td>{{ ++$key }}</td>
                    <td>{{ $category->name }}</td>
                    <td>
                        <a href="{{ route('admin.categories.edit', $category->id) }}" class="btn btn-warning btn-sm">Edit</a>
                        <form action="{{ route('admin.categories.destroy', $category->id) }}" method="POST" class="d-inline">
                            @csrf @method('DELETE')
                            <button class="btn btn-danger btn-sm" onclick="return confirm('Delete this category?')">Delete</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    {{ $categories->links() }}
</div>
        </div>
              </div>
        

@push('scripts')
    <!-- jQuery and Datatables JS -->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#blogsTable').DataTable({
                "paging": true, // Enable pagination
                "lengthChange": false, // Disable entries per page change
                "searching": true, // Enable search
                "ordering": true, // Enable column sorting
                "info": true, // Show information about current page
            });
        });
    </script>
@endpush

@include('admin.footer')
