
@include('admin.header')
<div class="container mt-5">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0 text-white">Order History for {{ $buyer->contact_person }}</h5>
            <a href="{{ route('admin.buyers.index') }}" class="btn btn-light btn-sm">← Back to Buyers</a>
        </div>
        <div class="card-body">
            @if($buyer->orders->isEmpty())
                <div class="alert alert-warning mb-0">No orders found.</div>
            @else
                <div class="table-responsive">
                    <table class="table table-striped table-hover align-middle">
                        <thead class="table-dark">
                            <tr>
                                <th scope="col">Order #</th>
                                <th scope="col">Product</th>
                                <th scope="col">Qty</th>
                                <th scope="col">Price</th>
                                <th scope="col">Order Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($buyer->orders as $order)
                                <tr>
                                    <td>{{ $order->order_number }}</td>
                                    <td>{{ $order->product }}</td>
                                    <td>{{ $order->quantity }}</td>
                                    <td>${{ number_format($order->price, 2) }}</td>
                                    <td>{{ \Carbon\Carbon::parse($order->order_date)->format('d M Y') }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    </div>
</div>

@include('admin.footer')
