@include('admin.header')

<div class="container mt-4">
    <h2 class="mb-4">Buyer List</h2>
    @if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="zmdi zmdi-check-circle"></i> {{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif

    <a href="{{ route('admin.buyers.create') }}" class="btn btn-primary mb-3" style="float:right;"> <i class="zmdi zmdi-plus"></i> Add Buyer</a>

    <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover">
            <thead class="thead-dark">
                <tr>
                    <th>Company</th>
                    <th>Contact</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Vat number</th>
                    <th>Fax number</th>
                    <th>Country</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($buyers as $buyer)
                <tr>
                    <td>{{ $buyer->company_name }}</td>
                    <td>{{ $buyer->contact_person }}</td>
                    <td>{{ $buyer->email }}</td>
                    <td>{{ $buyer->phone }}</td>
                    <td>{{ $buyer->vat }}</td>
                    <td>{{ $buyer->fax }}</td>
                    <td>{{ $buyer->country }}</td>
                    <td>

<div class="dropdown">
    <button class="btn btn-primary btn-sm dropdown-toggle" type="button" id="buyerActionsDropdown" data-bs-toggle="dropdown" aria-expanded="false">
        Actions
    </button>
    <ul class="dropdown-menu" aria-labelledby="buyerActionsDropdown">
        <li>
            <a class="dropdown-item" href="{{ route('admin.buyers.orders', ['id' => $buyer->id]) }}">
                <i class="fas fa-users me-1"></i> Order History
            </a>
        </li>
        <li>
            <a class="dropdown-item" href="{{ route('admin.buyers.edit', $buyer->id) }}">
                <i class="zmdi zmdi-edit me-1"></i> Update
            </a>
        </li>
        <li>    <form action="{{ route('admin.buyers.destroy', $buyer->id) }}" method="POST" style="display:inline;">
                            @csrf
                            @method('DELETE')
                            <button class=" dropdown-item " onclick="return confirm('Are you sure you want to delete this buyer?')"> <i class="zmdi zmdi-delete"></i> Delete</button>
                        </form></li>
    </ul>
</div>


                    
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
<div class="d-flex justify-content-center mt-4">
    {{ $buyers->links() }}
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

@include('admin.footer')

