@include('admin.header')
<div class="container mt-5">
    <h2 class="mb-4">Update Buyer</h2>

    <form action="{{ route('admin.buyers.update', $buyer->id) }}" method="POST" class="bg-white p-4 shadow rounded">
        @csrf
        @method('PUT')
        
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="company_name">Company Name <span class="text-danger">*</span></label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><i class="zmdi zmdi-city-alt"></i></span>
                    </div>
                    <input type="text" name="company_name" id="company_name" class="form-control" value="{{ old('company_name', $buyer->company_name) }}" required>
                </div>
            </div>

            <div class="form-group col-md-6">
                <label for="contact_person">Contact Person <span class="text-danger">*</span></label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><i class="zmdi zmdi-account"></i></span>
                    </div>
                    <input type="text" name="contact_person" id="contact_person" class="form-control" value="{{ old('contact_person', $buyer->contact_person) }}" required>
                </div>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="email">Email <span class="text-danger">*</span></label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><i class="zmdi zmdi-email"></i></span>
                    </div>
                    <input type="email" name="email" id="email" class="form-control" value="{{ old('email', $buyer->email) }}" required>
                </div>
                                   @error('email')
        <small class="text-danger"><i class="zmdi zmdi-alert-circle"></i> {{ $message }}</small>
    @enderror
            </div>

            <div class="form-group col-md-6">
                <label for="phone">Phone</label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><i class="zmdi zmdi-phone"></i></span>
                    </div>
                    <input type="text" name="phone" id="phone" class="form-control" value="{{ old('phone', $buyer->phone) }}">
                </div>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="country">Country</label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><i class="zmdi zmdi-globe"></i></span>
                    </div>
                    <input type="text" name="country" id="country" class="form-control" value="{{ old('country', $buyer->country) }}">
                </div>
            </div>

            <div class="form-group col-md-6">
                <label for="address">Address</label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><i class="zmdi zmdi-home"></i></span>
                    </div>
                    <textarea name="address" id="address" class="form-control" rows="2">{{ old('address', $buyer->address) }}</textarea>
                </div>
            </div>
        </div>


            <div class="form-row">
            <div class="form-group col-md-6">
                <label for="country">FAX </label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-white"><i class="zmdi zmdi-globe"></i></span>
                    </div>
                    <input type="text" name="fax" id="country" class="form-control" placeholder="Enter fax number" value="{{ old('fax', $buyer->fax) }}">
                </div>
            </div>

            <div class="form-group col-md-6">
                <label for="address">COMPANY VAT NUMBER</label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-white"><i class="zmdi zmdi-pin"></i></span>
                    </div>
                      <input type="text" name="vat" id="country" class="form-control" placeholder="Enter vat number" value="{{ old('vat', $buyer->vat) }}"> 
                </div>
            </div>
        </div>
   <div class="form-row">
      <div class="form-group col-md-6">
        <label for="bank_id">Select Bank</label>
        <select name="bank_id" id="bank_id" class="form-control">
          <option value="">-- None --</option>
          @foreach($banks as $bank)
            <option value="{{ $bank->id }}" 
              {{ old('bank_id', $buyer->bank_id) == $bank->id ? 'selected' : '' }}>
              {{ $bank->bank_name }} — {{ $bank->account_no }}
            </option>
          @endforeach
        </select>
      </div>
    </div>

    <!-- Bank Details -->
    <div id="bank-details" class="bank-details" style="display:none;">
      <h5>Bank details</h5>
      <p><strong>A/C NAME:</strong> <span id="bd-account_name"></span></p>
      <p><strong>A/C NO:</strong> <span id="bd-account_no"></span></p>
      <p><strong>IBAN:</strong> <span id="bd-iban"></span></p>
      <p><strong>SWIFT:</strong> <span id="bd-swift"></span></p>
      <p><strong>Bank Name:</strong> <span id="bd-bank_name"></span></p>
      <p><strong>Bank Address:</strong> <span id="bd-bank_address"></span></p>
      <p><strong>CORRESPONDENT BANK:</strong> <span id="bd-correspondent_bank"></span></p>
      <p><strong>CORRESPONDENT SWIFT:</strong> <span id="bd-correspondent_swift"></span></p>
      <p><strong>CORRESPONDENT A/C NO:</strong> <span id="bd-correspondent_account"></span></p>
    </div>


        <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Update Buyer
        </button>
    </form>
</div>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const bankSelect = document.getElementById('bank_id');
    const details = document.getElementById('bank-details');

    function loadBank(bankId) {
        if (!bankId) {
            details.style.display = 'none';
            return;
        }

        fetch("{{ url('admin/banks') }}/" + bankId + "/json", {
            headers: { 'X-Requested-With': 'XMLHttpRequest' }
        }).then(r => r.json()).then(data => {
            document.getElementById('bd-account_name').textContent = data.account_name || '';
            document.getElementById('bd-account_no').textContent = data.account_no || '';
            document.getElementById('bd-iban').textContent = data.iban || '';
            document.getElementById('bd-swift').textContent = data.swift || '';
            document.getElementById('bd-bank_name').textContent = data.bank_name || '';
            document.getElementById('bd-bank_address').textContent = data.bank_address || '';
            document.getElementById('bd-correspondent_bank').textContent = data.correspondent_bank || '';
            document.getElementById('bd-correspondent_swift').textContent = data.correspondent_swift || '';
            document.getElementById('bd-correspondent_account').textContent = data.correspondent_account || '';
            details.style.display = 'block';
        }).catch(err => {
            console.error(err);
            details.style.display = 'none';
        });
    }

    bankSelect.addEventListener('change', function () {
        loadBank(this.value);
    });

    // load on page load if buyer already has a bank
    @if(old('bank_id', $buyer->bank_id))
        loadBank("{{ old('bank_id', $buyer->bank_id) }}");
    @endif
});
</script>
@include('admin.footer')
