
      <div class="container">
        <h1 class="my-4">{{ isset($post) ? 'Update Blog' : 'Add New Blog' }}</h1>

        <form id="blogForm"  action="{{ isset($post) ? route('admin.posts.update', $post->id) : route('admin.posts.store') }}" method="POST" enctype="multipart/form-data">
          @csrf
          @if(isset($post))
            @method('PUT')
          @endif

          <div class="row">
            <div class="col-md-6">
              <div class="mb-3">
                <label for="title" class="form-label">Blog Title</label>
                <input type="text" class="form-control" id="title" name="title" value="{{ old('title', $post->title ?? '') }}" required>
              </div>
            </div>

            <div class="col-md-6">
              <div class="mb-3">
                <label for="category" class="form-label">Category</label>
                <select class="form-select" id="category" name="category_id" required>
                  @foreach($categories as $category)
                    <option value="{{ $category->id }}" {{ (old('category_id', $post->category_id ?? '') == $category->id) ? 'selected' : '' }}>{{ $category->name }}</option>
                  @endforeach
                </select>
              </div>
            </div>
          </div>

          <div class="mb-3">
            <label for="slug" class="form-label">Slug (unique)</label>
            <input type="text" class="form-control" id="slug" name="slug" value="{{ old('slug', $post->slug ?? '') }}" required>
          </div>

          <div class="mb-3">
            <label for="short_description" class="form-label">Short Description</label>
            <textarea class="form-control" id="short_description" name="short_description" rows="3" required>{{ old('short_description', $post->short_description ?? '') }}</textarea>
          </div>

          <div class="mb-3">
            <label for="image" class="form-label">Blog Image (WebP only)</label>
            <input type="file" class="form-control" id="image" name="image" accept=".webp">
            @if(isset($post) && $post->image)
              <br>
              <img src="{{ asset('blogs/'.$post->image) }}" width="150">
            @endif
          </div>

          <div class="mb-3">
            <label for="content" class="form-label">Content</label>
            <textarea class="form-control" id="editor" name="content" rows="5" >{{ old('content', $post->content ?? '') }}</textarea>
          </div>
          <div class="mb-3">
  <label for="tags" class="form-label">Tags (comma separated)</label>
  <input type="text" class="form-control" id="tags" name="tags" value="{{ old('tags', $post->tags ?? '') }}">
</div>

          <button type="submit" class="btn btn-primary">{{ isset($post) ? 'Update Blog' : 'Save Blog' }}</button>
        </form>
      </div>






