@include('admin.header')

<div class="container mt-5">
    <h2 class="mb-4">Banks List</h2>

    <a href="{{ route('admin.banks.create') }}" class="btn btn-success mb-3">
        <i class="fas fa-plus"></i> Add Bank
    </a>
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>ID</th>
                <th>A/C Name</th>
                <th>A/C No</th>
                <th>IBAN</th>
                <th>SWIFT</th>
                <th>Bank Name</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($banks as $bank)
                <tr>
                    <td>{{ $bank->id }}</td>
                    <td>{{ $bank->account_name }}</td>
                    <td>{{ $bank->account_no }}</td>
                    <td>{{ $bank->iban }}</td>
                    <td>{{ $bank->swift }}</td>
                    <td>{{ $bank->bank_name }}</td>
                    <td>
                        <a href="{{ route('admin.banks.edit', $bank->id) }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-edit"></i>
                        </a>

                          <a href="{{ route('admin.banks.show', $bank->id) }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-eye"></i>
                        </a>
                        <form action="{{ route('admin.banks.destroy', $bank->id) }}" method="POST" style="display:inline-block;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" onclick="return confirm('Are you sure?')" class="btn btn-danger btn-sm">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>

@include('admin.footer')
