@include('admin.header')

<div class="container mt-5">
    <h2 class="mb-4">Edit Bank</h2>

    <form action="{{ route('admin.banks.update', $bank->id) }}" method="POST" class="bg-white p-4 shadow rounded">
        @csrf
        @method('PUT')

        <div class="form-group">
            <label>A/C Name</label>
            <input type="text" name="account_name" class="form-control" value="{{ $bank->account_name }}" required>
        </div>

        <div class="form-group">
            <label>A/C No</label>
            <input type="text" name="account_no" class="form-control" value="{{ $bank->account_no }}" required>
        </div>

        <div class="form-group">
            <label>IBAN</label>
            <input type="text" name="iban" class="form-control" value="{{ $bank->iban }}" required>
        </div>

        <div class="form-group">
            <label>SWIFT</label>
            <input type="text" name="swift" class="form-control" value="{{ $bank->swift }}" required>
        </div>

        <div class="form-group">
            <label>Bank Name</label>
            <input type="text" name="bank_name" class="form-control" value="{{ $bank->bank_name }}" required>
        </div>

        <div class="form-group">
            <label>Bank Address</label>
            <textarea name="bank_address" class="form-control" rows="2">{{ $bank->bank_address }}</textarea>
        </div>

        <div class="form-group">
            <label>Correspondent Bank</label>
            <input type="text" name="correspondent_bank" class="form-control" value="{{ $bank->correspondent_bank }}">
        </div>

        <div class="form-group">
            <label>SWIFT of Correspondent Bank</label>
            <input type="text" name="correspondent_swift" class="form-control" value="{{ $bank->correspondent_swift }}">
        </div>

        <div class="form-group">
            <label>Correspondent A/C No</label>
            <input type="text" name="correspondent_account" class="form-control" value="{{ $bank->correspondent_account }}">
        </div>

        <button type="submit" class="btn btn-primary">Update</button>
        <a href="{{ route('admin.banks.index') }}" class="btn btn-secondary">Cancel</a>
    </form>
</div>

@include('admin.footer')
