<!-- resources/views/admin/audit-logs/show.blade.php -->
@include('admin.header')

@section('title', 'Audit Log Details')

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="fas fa-clipboard-list me-2"></i>Audit Log Details</h5>
                    <a href="{{ route('admin.audit-logs.index') }}" class="btn btn-secondary btn-sm">
                        <i class="fas fa-arrow-left me-1"></i>Back to Logs
                    </a>
                </div>
                <div class="card-body">
                    <div class="row">
                        <!-- Basic Information -->
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header bg-light">
                                    <h6 class="mb-0">Basic Information</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-sm table-borderless">
                                        <tr>
                                            <th width="30%">Log ID:</th>
                                            <td>#{{ $auditLog->id }}</td>
                                        </tr>
                                        <tr>
                                            <th>Action:</th>
                                            <td>
                                                @php
                                                    $actionColors = [
                                                        'created' => 'success',
                                                        'updated' => 'info',
                                                        'deleted' => 'danger',
                                                        'login' => 'primary',
                                                        'logout' => 'warning'
                                                    ];
                                                    $color = $actionColors[$auditLog->action] ?? 'secondary';
                                                @endphp
                                                <span class="badge bg-{{ $color }}">{{ ucfirst($auditLog->action) }}</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Module:</th>
                                            <td>
                                                <span class="badge bg-dark">{{ $auditLog->module }}</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Timestamp:</th>
                                            <td>
                                                <strong>{{ $auditLog->created_at->format('F d, Y') }}</strong><br>
                                                <small class="text-muted">{{ $auditLog->created_at->format('h:i:s A') }}</small>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>IP Address:</th>
                                            <td>
                                                <code>{{ $auditLog->ip_address }}</code>
                                            </td>
                                        </tr>
                                        @if($auditLog->user_agent)
                                        <tr>
                                            <th>User Agent:</th>
                                            <td>
                                                <small class="text-muted">{{ $auditLog->user_agent }}</small>
                                            </td>
                                        </tr>
                                        @endif
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- User Information -->
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header bg-light">
                                    <h6 class="mb-0">User Information</h6>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex align-items-center mb-3">
                                        @if($auditLog->admin->profile_image)
                                            <img src="{{ asset($auditLog->admin->profile_image) }}" class="rounded-circle me-3" width="60" height="60" alt="Profile">
                                        @else
                                            <div class="rounded-circle bg-secondary me-3 d-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                                                <i class="fas fa-user text-white"></i>
                                            </div>
                                        @endif
                                        <div>
                                            <h6 class="mb-0">{{ $auditLog->admin->name }}</h6>
                                            <p class="text-muted mb-0">{{ $auditLog->admin->email }}</p>
                                            <small class="text-muted">User ID: {{ $auditLog->admin->id }}</small>
                                        </div>
                                    </div>
                                    
                                    <div class="mt-3">
                                        <strong>User Roles:</strong>
                                        <div class="mt-1">
                                            @foreach($auditLog->admin->roles as $role)
                                                <span class="badge bg-primary me-1">{{ $role->name }}</span>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Description -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card mb-4">
                                <div class="card-header bg-light">
                                    <h6 class="mb-0">Description</h6>
                                </div>
                                <div class="card-body">
                                    <p class="mb-0 lead">{{ $auditLog->description }}</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Changes Data (If Available) -->
                    @if($auditLog->old_values || $auditLog->new_values)
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h6 class="mb-0">
                                        <i class="fas fa-exchange-alt me-2"></i>Data Changes
                                        @if($auditLog->old_values && $auditLog->new_values)
                                        <span class="badge bg-info ms-2">Updated Data</span>
                                        @elseif($auditLog->old_values && !$auditLog->new_values)
                                        <span class="badge bg-danger ms-2">Deleted Data</span>
                                        @elseif(!$auditLog->old_values && $auditLog->new_values)
                                        <span class="badge bg-success ms-2">Created Data</span>
                                        @endif
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        @if($auditLog->old_values)
                                        <div class="col-md-6">
                                            <h6 class="text-danger mb-3">
                                                <i class="fas fa-arrow-left me-1"></i>Old Values
                                            </h6>
                                            <div class="bg-light p-3 rounded" style="max-height: 300px; overflow-y: auto;">
                                                <pre class="mb-0" style="white-space: pre-wrap; font-size: 0.875rem;"><code>{{ json_encode($auditLog->old_values, JSON_PRETTY_PRINT) }}</code></pre>
                                            </div>
                                        </div>
                                        @endif

                                        @if($auditLog->new_values)
                                        <div class="col-md-6">
                                            <h6 class="text-success mb-3">
                                                <i class="fas fa-arrow-right me-1"></i>New Values
                                            </h6>
                                            <div class="bg-light p-3 rounded" style="max-height: 300px; overflow-y: auto;">
                                                <pre class="mb-0" style="white-space: pre-wrap; font-size: 0.875rem;"><code>{{ json_encode($auditLog->new_values, JSON_PRETTY_PRINT) }}</code></pre>
                                            </div>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @else
                    <!-- No Data Changes -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body text-center py-4">
                                    <i class="fas fa-info-circle fa-2x text-muted mb-3"></i>
                                    <h6 class="text-muted">No Detailed Data Changes Recorded</h6>
                                    <p class="text-muted mb-0">This log entry contains only basic activity information.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Action Buttons -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="d-flex justify-content-between">
                                <a href="{{ route('admin.audit-logs.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left me-1"></i>Back to All Logs
                                </a>
                                
                                <div>
                                    <button onclick="window.print()" class="btn btn-outline-primary me-2">
                                        <i class="fas fa-print me-1"></i>Print
                                    </button>
                                    <button onclick="window.history.back()" class="btn btn-outline-secondary">
                                        <i class="fas fa-times me-1"></i>Close
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
@media print {
    .btn, .card-header .btn {
        display: none !important;
    }
    
    .card {
        border: 1px solid #ddd !important;
        box-shadow: none !important;
    }
}
</style>

@include('admin.footer')