@include('admin.header')

@section('title', 'Audit Logs')

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-clipboard-list me-2"></i>Audit Logs</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover table-striped">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Timestamp</th>
                                    <th>User</th>
                                    <th>Action</th>
                                    <th>Module</th>
                                    <th>Description</th>
                                    <th>IP Address</th>
                                    <th>action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($logs as $log)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>
                                        <small class="text-muted">{{ $log->created_at->format('M d, Y') }}</small><br>
                                        <small>{{ $log->created_at->format('H:i:s') }}</small>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            @if($log->admin->profile_image)
                                                <img src="{{ asset($log->admin->profile_image) }}" class="rounded-circle me-2" width="30" height="30" alt="Profile">
                                            @else
                                                <div class="rounded-circle bg-secondary me-2 d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                                    <i class="fas fa-user text-white" style="font-size: 12px;"></i>
                                                </div>
                                            @endif
                                            <span>{{ $log->admin->name }}</span>
                                        </div>
                                    </td>
                                    <td>
                                        @php
                                            $actionColors = [
                                                'created' => 'success',
                                                'updated' => 'info', 
                                                'deleted' => 'danger',
                                                'login' => 'primary',
                                                'logout' => 'warning'
                                            ];
                                            $color = $actionColors[$log->action] ?? 'secondary';
                                        @endphp
                                        <span class="badge bg-{{ $color }}">{{ ucfirst($log->action) }}</span>
                                    </td>
                                    <td>{{ $log->module }}</td>
                                    <td>
                                        <span title="{{ $log->description }}">
                                            {{ Str::limit($log->description, 50) }}
                                        </span>
                                    </td>
                                    <td>
                                        <small class="text-muted">{{ $log->ip_address }}</small>
                                    </td>
                                          <td>
                                        <!-- 🔥 SHOW BUTTON -->
                                        <a href="{{ route('admin.audit-logs.show', $log) }}" class="btn btn-sm btn-outline-primary" title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <div class="text-muted">
                            Showing {{ $logs->firstItem() }} to {{ $logs->lastItem() }} of {{ $logs->total() }} entries
                        </div>
                        <div>
                            {{ $logs->links() }}
                        </div>
                    </div>

                    @if($logs->isEmpty())
                    <div class="text-center py-4">
                        <i class="fas fa-clipboard-list fa-3x text-muted mb-3"></i>
                        <h5>No Audit Logs Found</h5>
                        <p class="text-muted">Activity logs will appear here as users perform actions in the system.</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@include('admin.footer')
