<?php
// database/seeders/RoleSeeder.php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Role;
use App\Models\Permission;

class RoleSeeder extends Seeder
{
    public function run()
    {
        // Create Super Admin Role
        $superAdmin = Role::create([
            'name' => 'superadmin',
            'description' => 'Super Administrator with full access',
            'is_default' => false
        ]);
        
        // Create Admin Role
        $admin = Role::create([
            'name' => 'admin',
            'description' => 'Administrator with most access',
            'is_default' => false
        ]);
        
        // Create Manager Role
        $manager = Role::create([
            'name' => 'manager',
            'description' => 'Manager with limited administrative access',
            'is_default' => false
        ]);
        
        // Create User Role (Default)
        $user = Role::create([
            'name' => 'user',
            'description' => 'Regular user with basic access',
            'is_default' => true
        ]);
        
        // Assign all permissions to superadmin
        $superAdmin->permissions()->sync(Permission::pluck('id'));
        
        // Assign permissions to admin (all except user management)
        $adminPermissions = Permission::where('module', '!=', 'Users')->pluck('id');
        $admin->permissions()->sync($adminPermissions);
        
        // Assign permissions to manager
        $managerPermissions = Permission::whereIn('slug', [
            'view.dashboard',
            'view.reports',
            'view.quotations',
            'create.quotations',
            'edit.quotations',
            'view.orders',
            'create.orders',
            'edit.orders'
        ])->pluck('id');
        $manager->permissions()->sync($managerPermissions);
        
        // Assign basic permissions to user
        $userPermissions = Permission::whereIn('slug', [
            'view.dashboard',
            'view.quotations',
            'create.quotations',
            'view.orders'
        ])->pluck('id');
        $user->permissions()->sync($userPermissions);
    }
}