<?php
// database/seeders/PermissionSeeder.php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;

class PermissionSeeder extends Seeder
{
    public function run()
    {
        $permissions = [
            // ==================== DASHBOARD ====================
            ['name' => 'View Dashboard', 'slug' => 'view.dashboard', 'module' => 'Dashboard'],
            
            // ==================== USER MANAGEMENT ====================
            ['name' => 'View Users', 'slug' => 'view.users', 'module' => 'Users'],
            ['name' => 'Create Users', 'slug' => 'create.users', 'module' => 'Users'],
            ['name' => 'Edit Users', 'slug' => 'edit.users', 'module' => 'Users'],
            ['name' => 'Delete Users', 'slug' => 'delete.users', 'module' => 'Users'],
            ['name' => 'Manage Roles', 'slug' => 'manage.roles', 'module' => 'Users'],
            ['name' => 'Manage Permissions', 'slug' => 'manage.permissions', 'module' => 'Users'],
            
            // ==================== REPORTS & ANALYTICS ====================
            ['name' => 'View Reports', 'slug' => 'view.reports', 'module' => 'Reports'],
            ['name' => 'Export Reports', 'slug' => 'export.reports', 'module' => 'Reports'],
            
            // ==================== PAYMENT MANAGEMENT ====================
            ['name' => 'View Payments', 'slug' => 'view.payments', 'module' => 'Payments'],
            ['name' => 'Manage Payments', 'slug' => 'manage.payments', 'module' => 'Payments'],
            ['name' => 'View Advance Payments', 'slug' => 'view.advance.payments', 'module' => 'Payments'],
            ['name' => 'Manage Advance Payments', 'slug' => 'manage.advance.payments', 'module' => 'Payments'],
            ['name' => 'View Payment Allocations', 'slug' => 'view.payment.allocations', 'module' => 'Payments'],
            ['name' => 'Manage Payment Allocations', 'slug' => 'manage.payment.allocations', 'module' => 'Payments'],
            ['name' => 'View Bank Invoices', 'slug' => 'view.bank.invoices', 'module' => 'Payments'],
            ['name' => 'Manage Bank Invoices', 'slug' => 'manage.bank.invoices', 'module' => 'Payments'],
            ['name' => 'View Payment Ledger', 'slug' => 'view.payment.ledger', 'module' => 'Payments'],
            
            // ==================== SHIPMENT & LOGISTICS ====================
            ['name' => 'View Shipments', 'slug' => 'view.shipments', 'module' => 'Shipments'],
            ['name' => 'Manage Shipments', 'slug' => 'manage.shipments', 'module' => 'Shipments'],
            ['name' => 'View Carton Details', 'slug' => 'view.carton.details', 'module' => 'Shipments'],
            ['name' => 'Manage Carton Details', 'slug' => 'manage.carton.details', 'module' => 'Shipments'],
            ['name' => 'View Booking Invoices', 'slug' => 'view.booking.invoices', 'module' => 'Shipments'],
            ['name' => 'Manage Booking Invoices', 'slug' => 'manage.booking.invoices', 'module' => 'Shipments'],
            ['name' => 'View Final Shipments', 'slug' => 'view.final.shipments', 'module' => 'Shipments'],
            ['name' => 'Manage Final Shipments', 'slug' => 'manage.final.shipments', 'module' => 'Shipments'],
            
            // ==================== DOCUMENT MANAGEMENT ====================
            ['name' => 'View Document Generator', 'slug' => 'view.document.generator', 'module' => 'Documents'],
            ['name' => 'Manage Document Generator', 'slug' => 'manage.document.generator', 'module' => 'Documents'],
            ['name' => 'View Document Templates', 'slug' => 'view.document.templates', 'module' => 'Documents'],
            ['name' => 'Manage Document Templates', 'slug' => 'manage.document.templates', 'module' => 'Documents'],
            
            // ==================== EXPORT & EMAIL ====================
            ['name' => 'View Export Center', 'slug' => 'view.export.center', 'module' => 'Export'],
            ['name' => 'Manage Export Center', 'slug' => 'manage.export.center', 'module' => 'Export'],
            ['name' => 'View Email Logs', 'slug' => 'view.email.logs', 'module' => 'Export'],
            ['name' => 'Manage Email Logs', 'slug' => 'manage.email.logs', 'module' => 'Export'],
            
            // ==================== BUYER MANAGEMENT ====================
            ['name' => 'View Buyers', 'slug' => 'view.buyers', 'module' => 'Buyers'],
            ['name' => 'Manage Buyers', 'slug' => 'manage.buyers', 'module' => 'Buyers'],
            
            // ==================== FACTORY MANAGEMENT ====================
            ['name' => 'View Factories', 'slug' => 'view.factories', 'module' => 'Factories'],
            ['name' => 'Manage Factories', 'slug' => 'manage.factories', 'module' => 'Factories'],
            
            // ==================== INFORMATION LIBRARY ====================
            ['name' => 'View Information Library', 'slug' => 'view.information.library', 'module' => 'Library'],
            ['name' => 'Manage Information Library', 'slug' => 'manage.information.library', 'module' => 'Library'],
            ['name' => 'View Brands', 'slug' => 'view.brands', 'module' => 'Library'],
            ['name' => 'Manage Brands', 'slug' => 'manage.brands', 'module' => 'Library'],
            ['name' => 'View Item Descriptions', 'slug' => 'view.item.descriptions', 'module' => 'Library'],
            ['name' => 'Manage Item Descriptions', 'slug' => 'manage.item.descriptions', 'module' => 'Library'],
            ['name' => 'View Size Ranges', 'slug' => 'view.size.ranges', 'module' => 'Library'],
            ['name' => 'Manage Size Ranges', 'slug' => 'manage.size.ranges', 'module' => 'Library'],
            ['name' => 'View Colors', 'slug' => 'view.colors', 'module' => 'Library'],
            ['name' => 'Manage Colors', 'slug' => 'manage.colors', 'module' => 'Library'],
            ['name' => 'View Fabric Compositions', 'slug' => 'view.fabric.compositions', 'module' => 'Library'],
            ['name' => 'Manage Fabric Compositions', 'slug' => 'manage.fabric.compositions', 'module' => 'Library'],
            ['name' => 'View Fabric Types', 'slug' => 'view.fabric.types', 'module' => 'Library'],
            ['name' => 'Manage Fabric Types', 'slug' => 'manage.fabric.types', 'module' => 'Library'],
            ['name' => 'View Yarn Counts', 'slug' => 'view.yarn.counts', 'module' => 'Library'],
            ['name' => 'Manage Yarn Counts', 'slug' => 'manage.yarn.counts', 'module' => 'Library'],
            ['name' => 'View Fabric Weights', 'slug' => 'view.fabric.weights', 'module' => 'Library'],
            ['name' => 'Manage Fabric Weights', 'slug' => 'manage.fabric.weights', 'module' => 'Library'],
            ['name' => 'View Port of Landings', 'slug' => 'view.port.landings', 'module' => 'Library'],
            ['name' => 'Manage Port of Landings', 'slug' => 'manage.port.landings', 'module' => 'Library'],
            ['name' => 'View Country of Origins', 'slug' => 'view.country.origins', 'module' => 'Library'],
            ['name' => 'Manage Country of Origins', 'slug' => 'manage.country.origins', 'module' => 'Library'],
            ['name' => 'View Port of Discharges', 'slug' => 'view.port.discharges', 'module' => 'Library'],
            ['name' => 'Manage Port of Discharges', 'slug' => 'manage.port.discharges', 'module' => 'Library'],
            ['name' => 'View Final Destinations', 'slug' => 'view.final.destinations', 'module' => 'Library'],
            ['name' => 'Manage Final Destinations', 'slug' => 'manage.final.destinations', 'module' => 'Library'],
            ['name' => 'View Delivery Terms', 'slug' => 'view.delivery.terms', 'module' => 'Library'],
            ['name' => 'Manage Delivery Terms', 'slug' => 'manage.delivery.terms', 'module' => 'Library'],
            ['name' => 'View Shipment Modes', 'slug' => 'view.shipment.modes', 'module' => 'Library'],
            ['name' => 'Manage Shipment Modes', 'slug' => 'manage.shipment.modes', 'module' => 'Library'],
            ['name' => 'View Payment Terms', 'slug' => 'view.payment.terms', 'module' => 'Library'],
            ['name' => 'Manage Payment Terms', 'slug' => 'manage.payment.terms', 'module' => 'Library'],
            ['name' => 'View Payment Modes', 'slug' => 'view.payment.modes', 'module' => 'Library'],
            ['name' => 'Manage Payment Modes', 'slug' => 'manage.payment.modes', 'module' => 'Library'],
            ['name' => 'View RFQs', 'slug' => 'view.rfqs', 'module' => 'Library'],
            ['name' => 'Manage RFQs', 'slug' => 'manage.rfqs', 'module' => 'Library'],
            ['name' => 'View Inquiries', 'slug' => 'view.inquiries', 'module' => 'Library'],
            ['name' => 'Manage Inquiries', 'slug' => 'manage.inquiries', 'module' => 'Library'],
            
            // ==================== QUOTATION MANAGEMENT ====================
            ['name' => 'View Quotations', 'slug' => 'view.quotations', 'module' => 'Quotations'],
            ['name' => 'Create Quotations', 'slug' => 'create.quotations', 'module' => 'Quotations'],
            ['name' => 'Edit Quotations', 'slug' => 'edit.quotations', 'module' => 'Quotations'],
            ['name' => 'Delete Quotations', 'slug' => 'delete.quotations', 'module' => 'Quotations'],
            ['name' => 'Approve Quotations', 'slug' => 'approve.quotations', 'module' => 'Quotations'],
            ['name' => 'Convert Quotations to Orders', 'slug' => 'convert.quotations', 'module' => 'Quotations'],
            
            // ==================== ORDER MANAGEMENT ====================
            ['name' => 'View Orders', 'slug' => 'view.orders', 'module' => 'Orders'],
            ['name' => 'Create Orders', 'slug' => 'create.orders', 'module' => 'Orders'],
            ['name' => 'Edit Orders', 'slug' => 'edit.orders', 'module' => 'Orders'],
            ['name' => 'Delete Orders', 'slug' => 'delete.orders', 'module' => 'Orders'],
            ['name' => 'Manage Order Documents', 'slug' => 'manage.order.documents', 'module' => 'Orders'],
            ['name' => 'View Order Dashboard', 'slug' => 'view.order.dashboard', 'module' => 'Orders'],
            
            // ==================== COST & PRICING ====================
            ['name' => 'View Yarn Types', 'slug' => 'view.yarn.types', 'module' => 'Costs'],
            ['name' => 'Manage Yarn Types', 'slug' => 'manage.yarn.types', 'module' => 'Costs'],
            ['name' => 'View Knitting Types', 'slug' => 'view.knitting.types', 'module' => 'Costs'],
            ['name' => 'Manage Knitting Types', 'slug' => 'manage.knitting.types', 'module' => 'Costs'],
            ['name' => 'View Dyeing Types', 'slug' => 'view.dyeing.types', 'module' => 'Costs'],
            ['name' => 'Manage Dyeing Types', 'slug' => 'manage.dyeing.types', 'module' => 'Costs'],
            ['name' => 'View Fabric Addons', 'slug' => 'view.fabric.addons', 'module' => 'Costs'],
            ['name' => 'Manage Fabric Addons', 'slug' => 'manage.fabric.addons', 'module' => 'Costs'],
            ['name' => 'View Accessories', 'slug' => 'view.accessories', 'module' => 'Costs'],
            ['name' => 'Manage Accessories', 'slug' => 'manage.accessories', 'module' => 'Costs'],
            ['name' => 'View Other Costs', 'slug' => 'view.other.costs', 'module' => 'Costs'],
            ['name' => 'Manage Other Costs', 'slug' => 'manage.other.costs', 'module' => 'Costs'],
            ['name' => 'View Commercial Rates', 'slug' => 'view.commercial.rates', 'module' => 'Costs'],
            ['name' => 'Manage Commercial Rates', 'slug' => 'manage.commercial.rates', 'module' => 'Costs'],
            ['name' => 'View Garment Addons', 'slug' => 'view.garment.addons', 'module' => 'Costs'],
            ['name' => 'Manage Garment Addons', 'slug' => 'manage.garment.addons', 'module' => 'Costs'],
            ['name' => 'View Costs', 'slug' => 'view.costs', 'module' => 'Costs'],
            ['name' => 'Manage Costs', 'slug' => 'manage.costs', 'module' => 'Costs'],
            
            // ==================== BANK & SELLER ====================
            ['name' => 'View Banks', 'slug' => 'view.banks', 'module' => 'Banks'],
            ['name' => 'Manage Banks', 'slug' => 'manage.banks', 'module' => 'Banks'],
            ['name' => 'View Sellers', 'slug' => 'view.sellers', 'module' => 'Banks'],
            ['name' => 'Manage Sellers', 'slug' => 'manage.sellers', 'module' => 'Banks'],
            ['name' => 'View Terms', 'slug' => 'view.terms', 'module' => 'Banks'],
            ['name' => 'Manage Terms', 'slug' => 'manage.terms', 'module' => 'Banks'],
            
            // ==================== BLOG MANAGEMENT ====================
            ['name' => 'View Blogs', 'slug' => 'view.blogs', 'module' => 'Blogs'],
            ['name' => 'Manage Blogs', 'slug' => 'manage.blogs', 'module' => 'Blogs'],
            ['name' => 'View Blog Categories', 'slug' => 'view.blog.categories', 'module' => 'Blogs'],
            ['name' => 'Manage Blog Categories', 'slug' => 'manage.blog.categories', 'module' => 'Blogs'],
            
            // ==================== AUDIT LOGS ====================
            ['name' => 'View Audit Logs', 'slug' => 'view.audit.logs', 'module' => 'Audit'],
        ];
        
        foreach ($permissions as $permission) {
            Permission::create($permission);
        }
    }
}