<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\DocumentTemplate;

class DocumentTemplatesSeeder extends Seeder
{
    public function run()
    {
        $templates = [
            [
                'name' => 'Standard Commercial Invoice',
                'type' => 'commercial_invoice',
                'content' => $this->getCommercialInvoiceTemplate(),
                'variables' => null,
                'is_active' => true,
                'is_default' => true,
                'created_by' => 1,
            ],
            [
                'name' => 'Standard Packing List',
                'type' => 'packing_list', 
                'content' => $this->getPackingListTemplate(),
                'variables' => null,
                'is_active' => true,
                'is_default' => true,
                'created_by' => 1,
            ],
            [
                'name' => 'Standard Certificate of Origin',
                'type' => 'certificate_origin',
                'content' => $this->getCertificateOriginTemplate(),
                'variables' => null,
                'is_active' => true,
                'is_default' => true,
                'created_by' => 1,
            ],
            [
                'name' => 'Standard Bill of Lading',
                'type' => 'bill_of_lading',
                'content' => $this->getBillOfLadingTemplate(),
                'variables' => null,
                'is_active' => true,
                'is_default' => true,
                'created_by' => 1,
            ],
            [
                'name' => 'Standard Inspection Certificate', 
                'type' => 'inspection_certificate',
                'content' => $this->getInspectionCertificateTemplate(),
                'variables' => null,
                'is_active' => true,
                'is_default' => true,
                'created_by' => 1,
            ],
            [
                'name' => 'Standard Shipping Label',
                'type' => 'shipping_label',
                'content' => $this->getShippingLabelTemplate(),
                'variables' => null,
                'is_active' => true,
                'is_default' => true,
                'created_by' => 1,
            ],
        ];

        foreach ($templates as $template) {
            DocumentTemplate::create($template);
        }
    }

    private function getCommercialInvoiceTemplate()
    {
        return '<!DOCTYPE html>
        <html>
        <head>
            <meta charset="utf-8">
            <title>Commercial Invoice - {order_number}</title>
            <style>
                body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
                .header { text-align: center; margin-bottom: 20px; border-bottom: 2px solid #000; padding-bottom: 10px; }
                .section { margin-bottom: 15px; }
                .section-title { background: #f8f9fa; padding: 5px; font-weight: bold; border: 1px solid #ddd; }
                table { width: 100%; border-collapse: collapse; }
                th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
                th { background-color: #f8f9fa; }
                .text-right { text-align: right; }
                .signature { margin-top: 50px; }
            </style>
        </head>
        <body>
            <div class="header">
                <h2>COMMERCIAL INVOICE</h2>
                <p>Invoice No: {order_number}</p>
                <p>Date: {current_date}</p>
            </div>

            <div class="section">
                <div class="section-title">Order Information</div>
                <table>
                    <tr>
                        <td width="25%"><strong>Order Number:</strong></td>
                        <td>{order_number}</td>
                        <td width="25%"><strong>Customer PO:</strong></td>
                        <td>{customer_po_number}</td>
                    </tr>
                    <tr>
                        <td><strong>Quantity:</strong></td>
                        <td>{confirmed_quantity}</td>
                        <td><strong>Price:</strong></td>
                        <td>${confirmed_price}</td>
                    </tr>
                    <tr>
                        <td><strong>Delivery Date:</strong></td>
                        <td>{delivery_date}</td>
                        <td><strong>Total Value:</strong></td>
                        <td>${total_value}</td>
                    </tr>
                </table>
            </div>

            <div class="section">
                <div class="section-title">Payment Terms</div>
                <p>{payment_terms}</p>
            </div>

            <div class="section">
                <div class="section-title">Special Instructions</div>
                <p>{special_instructions}</p>
            </div>

            <div class="signature">
                <table>
                    <tr>
                        <td width="50%">
                            <strong>Seller Signature:</strong><br><br>
                            _________________________<br>
                            Name: ___________________<br>
                            Date: ___________________
                        </td>
                        <td width="50%">
                            <strong>Buyer Signature:</strong><br><br>
                            _________________________<br>
                            Name: ___________________<br>
                            Date: ___________________
                        </td>
                    </tr>
                </table>
            </div>

            <div class="section">
                <div class="section-title">Terms & Conditions</div>
                <p>1. All payments must be made in full before shipment.<br>
                   2. Delivery dates are estimates and not guaranteed.<br>
                   3. Returns must be requested within 7 days of receipt.</p>
            </div>
        </body>
        </html>';
    }

    private function getPackingListTemplate()
    {
        return '<!DOCTYPE html>
        <html>
        <head>
            <meta charset="utf-8">
            <title>Packing List - {order_number}</title>
            <style>
                body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
                .header { text-align: center; margin-bottom: 20px; }
                .section { margin-bottom: 15px; }
                .section-title { background: #f8f9fa; padding: 5px; font-weight: bold; }
                table { width: 100%; border-collapse: collapse; }
                th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
                th { background-color: #f8f9fa; }
                .text-right { text-align: right; }
                .text-center { text-align: center; }
            </style>
        </head>
        <body>
            <div class="header">
                <h2>PACKING LIST</h2>
                <p>Order No: {order_number}</p>
                <p>Date: {current_date}</p>
            </div>

            <div class="section">
                <div class="section-title">Order Information</div>
                <table>
                    <tr>
                        <td width="25%"><strong>Order Number:</strong></td>
                        <td>{order_number}</td>
                        <td width="25%"><strong>Customer PO:</strong></td>
                        <td>{customer_po_number}</td>
                    </tr>
                    <tr>
                        <td><strong>Total Quantity:</strong></td>
                        <td>{confirmed_quantity} units</td>
                        <td><strong>Delivery Date:</strong></td>
                        <td>{delivery_date}</td>
                    </tr>
                </table>
            </div>

            <div class="section">
                <div class="section-title">Packing Details</div>
                <table>
                    <thead>
                        <tr>
                            <th>Carton No</th>
                            <th>Description</th>
                            <th>Quantity</th>
                            <th>Weight (kg)</th>
                            <th>Dimensions (cm)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="text-center">1</td>
                            <td>Carton 1 - Order {order_number}</td>
                            <td class="text-center">{confirmed_quantity}</td>
                            <td class="text-center">20</td>
                            <td class="text-center">40x30x30</td>
                        </tr>
                        <tr>
                            <td colspan="2" class="text-right"><strong>Total:</strong></td>
                            <td class="text-center"><strong>{confirmed_quantity}</strong></td>
                            <td class="text-center"><strong>20 kg</strong></td>
                            <td></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </body>
        </html>';
    }

    private function getCertificateOriginTemplate()
    {
        return '<!DOCTYPE html>
        <html>
        <head>
            <meta charset="utf-8">
            <title>Certificate of Origin - {order_number}</title>
            <style>
                body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
                .header { text-align: center; margin-bottom: 20px; border-bottom: 2px solid #000; padding-bottom: 10px; }
                .section { margin-bottom: 15px; }
                .section-title { background: #f8f9fa; padding: 5px; font-weight: bold; }
                table { width: 100%; border-collapse: collapse; }
                th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
                th { background-color: #f8f9fa; }
                .official-stamp { margin-top: 50px; text-align: center; }
            </style>
        </head>
        <body>
            <div class="header">
                <h2>CERTIFICATE OF ORIGIN</h2>
                <p><strong>Trade Document</strong></p>
            </div>

            <div class="section">
                <table>
                    <tr>
                        <td width="30%"><strong>Certificate No:</strong></td>
                        <td>CO-{order_number}-{current_year}</td>
                        <td width="30%"><strong>Date of Issue:</strong></td>
                        <td>{current_date}</td>
                    </tr>
                </table>
            </div>

            <div class="section">
                <div class="section-title">Goods Description</div>
                <table>
                    <thead>
                        <tr>
                            <th>Order No</th>
                            <th>Description of Goods</th>
                            <th>Quantity</th>
                            <th>Value (USD)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>{order_number}</td>
                            <td>Commercial goods as per order confirmation</td>
                            <td>{confirmed_quantity} units</td>
                            <td>${total_value}</td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="section">
                <div class="section-title">Origin Criteria</div>
                <p>The undersigned hereby declares that the above mentioned goods originate in accordance with the rules of origin of the exporting country.</p>
            </div>

            <div class="official-stamp">
                <p>_________________________</p>
                <p><strong>Authorized Signature</strong></p>
                <p>Name: ___________________</p>
                <p>Position: ________________</p>
                <p>Date: {current_date}</p>
            </div>
        </body>
        </html>';
    }

    private function getBillOfLadingTemplate()
    {
        return '<!DOCTYPE html>
        <html>
        <head>
            <meta charset="utf-8">
            <title>Bill of Lading - {order_number}</title>
            <style>
                body { font-family: DejaVu Sans, sans-serif; font-size: 11px; }
                .header { text-align: center; margin-bottom: 15px; border-bottom: 2px solid #000; padding-bottom: 10px; }
                .section { margin-bottom: 12px; }
                .section-title { background: #f8f9fa; padding: 4px; font-weight: bold; border: 1px solid #ddd; }
                table { width: 100%; border-collapse: collapse; margin-bottom: 10px; }
                th, td { border: 1px solid #ddd; padding: 6px; text-align: left; }
                th { background-color: #f8f9fa; }
                .bordered-box { border: 1px solid #000; padding: 10px; margin-bottom: 10px; }
            </style>
        </head>
        <body>
            <div class="header">
                <h2>BILL OF LADING</h2>
                <p><strong>Non-Negotiable</strong></p>
            </div>

            <div class="section">
                <table>
                    <tr>
                        <td width="20%"><strong>B/L No:</strong></td>
                        <td>BL-{order_number}-{current_year}</td>
                        <td width="20%"><strong>Date:</strong></td>
                        <td>{current_date}</td>
                    </tr>
                </table>
            </div>

            <div class="section">
                <div class="section-title">CONTAINER AND GOODS DESCRIPTION</div>
                <table>
                    <thead>
                        <tr>
                            <th>Container No</th>
                            <th>Description of Goods</th>
                            <th>Gross Weight (kg)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>CONT{order_number}</td>
                            <td>COMMERCIAL GOODS - ORDER {order_number}</td>
                            <td>10000</td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div style="margin-top: 50px;">
                <table>
                    <tr>
                        <td width="50%" style="border: none; padding: 20px;">
                            <strong>FOR CARRIER:</strong><br><br>
                            _________________________<br>
                            <strong>Authorized Signature</strong><br>
                            Date: {current_date}
                        </td>
                    </tr>
                </table>
            </div>
        </body>
        </html>';
    }

    private function getInspectionCertificateTemplate()
    {
        return '<!DOCTYPE html>
        <html>
        <head>
            <meta charset="utf-8">
            <title>Inspection Certificate - {order_number}</title>
            <style>
                body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
                .header { text-align: center; margin-bottom: 20px; border-bottom: 2px solid #000; padding-bottom: 10px; }
                .section { margin-bottom: 15px; }
                .section-title { background: #f8f9fa; padding: 5px; font-weight: bold; border: 1px solid #ddd; }
                table { width: 100%; border-collapse: collapse; }
                th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
                th { background-color: #f8f9fa; }
            </style>
        </head>
        <body>
            <div class="header">
                <h2>INSPECTION CERTIFICATE</h2>
                <p><strong>Quality Control Document</strong></p>
            </div>

            <div class="section">
                <table>
                    <tr>
                        <td width="25%"><strong>Certificate No:</strong></td>
                        <td>IC-{order_number}-{current_year}</td>
                        <td width="25%"><strong>Inspection Date:</strong></td>
                        <td>{current_date}</td>
                    </tr>
                    <tr>
                        <td><strong>Order Number:</strong></td>
                        <td>{order_number}</td>
                        <td><strong>Customer PO:</strong></td>
                        <td>{customer_po_number}</td>
                    </tr>
                </table>
            </div>

            <div class="section">
                <div class="section-title">INSPECTION RESULTS</div>
                <table>
                    <thead>
                        <tr>
                            <th>Inspection Item</th>
                            <th>Result</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Quantity Verification</td>
                            <td>{confirmed_quantity} units</td>
                            <td>✓ PASS</td>
                        </tr>
                        <tr>
                            <td>Quality Check</td>
                            <td>Standard quality</td>
                            <td>✓ PASS</td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="section">
                <div class="section-title">CONCLUSION</div>
                <div style="padding: 15px; background: #f8f9fa; border: 1px solid #ddd;">
                    <p><strong>OVERALL RESULT: PASSED</strong></p>
                    <p>The inspected goods meet the required quality standards and specifications.</p>
                </div>
            </div>
        </body>
        </html>';
    }

    private function getShippingLabelTemplate()
    {
        return '<!DOCTYPE html>
        <html>
        <head>
            <meta charset="utf-8">
            <title>Shipping Label - {order_number}</title>
            <style>
                body { font-family: DejaVu Sans, sans-serif; font-size: 10px; margin: 0; padding: 10px; }
                .label-container { width: 100mm; height: 150mm; border: 2px solid #000; padding: 5mm; margin: 0 auto; }
                .header { text-align: center; border-bottom: 1px solid #000; padding-bottom: 3mm; margin-bottom: 3mm; }
                .section { margin-bottom: 3mm; }
                .address-box { border: 1px solid #000; padding: 3mm; margin-bottom: 3mm; }
            </style>
        </head>
        <body>
            <div class="label-container">
                <div class="header">
                    <h3 style="margin: 0; font-size: 12px;">SHIPPING LABEL</h3>
                </div>

                <div class="section">
                    <div class="address-box">
                        <strong>SHIP TO:</strong><br>
                        Customer Name<br>
                        Customer Address<br>
                        City, Country
                    </div>
                </div>

                <div class="section">
                    <table style="width: 100%; border-collapse: collapse; font-size: 9px;">
                        <tr>
                            <td><strong>Order No:</strong></td>
                            <td>{order_number}</td>
                        </tr>
                        <tr>
                            <td><strong>PO Number:</strong></td>
                            <td>{customer_po_number}</td>
                        </tr>
                        <tr>
                            <td><strong>Date:</strong></td>
                            <td>{current_date}</td>
                        </tr>
                    </table>
                </div>

                <div class="section" style="text-align: center; font-size: 8px;">
                    <strong>SHIPPING MARKS:</strong><br>
                    ORDER: {order_number}<br>
                    MADE IN: ORIGIN<br>
                    WT: 20 kg
                </div>
            </div>
        </body>
        </html>';
    }
}