<?php
// database/seeders/DatabaseSeeder.php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Admin;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // User::factory(10)->create();

        User::factory()->create([
            'name' => 'Test User',
            'email' => 'test@example.com',
        ]);

        // 🔥 YEH NAYA CODE ADD KAREIN - START
        // 1. Permissions aur Roles seed karein
        $this->call([
            PermissionSeeder::class,
            RoleSeeder::class,
        ]);

        // 2. Super Admin Create Karein (agar already nahi hai)
        $this->createSuperAdmin();
        // 🔥 YEH NAYA CODE ADD KAREIN - END
    }

    // 🔥 YEH NAYA METHOD ADD KAREIN
    protected function createSuperAdmin()
    {
        // Check if super admin already exists
        $existingAdmin = Admin::where('email', 'superadmin@example.com')->first();
        
        if (!$existingAdmin) {
            $superAdmin = Admin::create([
                'name' => 'Super Admin',
                'email' => 'superadmin@example.com',
                'password' => Hash::make('password'), // Default password
            ]);

            // Super Admin role assign karein
            $superAdminRole = \App\Models\Role::where('name', 'superadmin')->first();
            if ($superAdminRole) {
                $superAdmin->roles()->attach($superAdminRole->id);
            }

            $this->command->info('Super Admin created successfully!');
            $this->command->info('Email: superadmin@example.com');
            $this->command->info('Password: password');
        } else {
            $this->command->info('Super Admin already exists!');
        }
    }
}