<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
{
    Schema::create('email_logs', function (Blueprint $table) {
        $table->id();
        $table->foreignId('generated_document_id')->constrained()->onDelete('cascade');
        $table->string('recipient_email');
        $table->string('recipient_name')->nullable();
        $table->string('subject');
        $table->text('message')->nullable();
        $table->enum('status', ['sent', 'failed', 'pending'])->default('pending');
        $table->timestamp('sent_at')->nullable();
        $table->foreignId('sent_by')->constrained('users');
        $table->timestamps();
    });
}
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('email_logs');
    }
};
