<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up()
{
    Schema::create('generated_documents', function (Blueprint $table) {
        $table->id();
        $table->foreignId('order_confirmation_id')->constrained()->onDelete('cascade');
        $table->string('document_type');
        $table->string('file_name');
        $table->string('file_path');
        $table->integer('file_size');
        $table->json('generation_data')->nullable();
        $table->foreignId('generated_by')->constrained('users');
        $table->timestamps();
    });
}
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('generated_documents');
    }
};
