<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
 public function up()
{
    Schema::create('document_templates', function (Blueprint $table) {
        $table->id();
        $table->string('name');
        $table->enum('type', ['commercial_invoice', 'packing_list', 'certificate_origin', 'bill_of_lading', 'inspection_certificate', 'shipping_label']);
        $table->text('content');
        $table->json('variables')->nullable();
        $table->boolean('is_active')->default(true);
        $table->boolean('is_default')->default(false);
        $table->foreignId('created_by')->constrained('users');
        $table->timestamps();
    });
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('document_templates');
    }
};
