<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('final_shipments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('shipment_id')->constrained()->onDelete('cascade');
            $table->integer('original_quantity');
            $table->integer('adjusted_quantity');
            $table->integer('final_quantity');
            $table->text('adjustment_reason')->nullable();
            $table->date('final_shipment_date');
            $table->string('final_invoice_path')->nullable();
            $table->string('final_packing_list_path')->nullable();
            $table->text('inspection_remarks')->nullable();
            $table->enum('status', ['pending', 'adjusted', 'completed'])->default('pending');
            $table->foreignId('created_by')->constrained('users');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('final_shipments');
    }
};