<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('carton_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('shipment_id')->constrained()->onDelete('cascade');
            $table->string('carton_number');
            $table->integer('quantity');
            $table->decimal('gross_weight', 8, 2)->nullable();
            $table->decimal('net_weight', 8, 2)->nullable();
            $table->decimal('volume', 8, 3)->nullable();
            $table->text('description')->nullable();
            $table->timestamps();
            
            $table->unique(['shipment_id', 'carton_number']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('carton_details');
    }
};