<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('payment_ledgers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('buyer_id')->constrained()->onDelete('cascade');
            $table->decimal('total_in', 15, 2)->default(0);
            $table->decimal('total_out', 15, 2)->default(0);
            $table->decimal('current_balance', 15, 2)->default(0);
            $table->timestamp('last_updated')->useCurrent();
            $table->timestamps();

            // Unique constraint - one ledger per buyer
            $table->unique('buyer_id');
        });
    }

    public function down()
    {
        Schema::dropIfExists('payment_ledgers');
    }
};