<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('advance_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('buyer_id')->constrained()->onDelete('cascade');
            $table->foreignId('order_confirmation_id')->nullable()->constrained()->onDelete('set null');
            $table->string('reference_number')->unique();
            $table->decimal('amount', 15, 2);
            $table->date('payment_date');
            $table->enum('payment_method', ['bank_transfer', 'lc', 'tt', 'cash', 'cheque']);
            $table->string('transaction_id')->nullable();
            $table->text('remarks')->nullable();
            $table->enum('status', ['pending', 'received', 'cancelled'])->default('received');
            $table->decimal('allocated_amount', 15, 2)->default(0);
            $table->decimal('remaining_amount', 15, 2)->default(0);
            $table->foreignId('created_by')->constrained('users');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('advance_payments');
    }
};