<?php


use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


return new class extends Migration {
public function up(): void
{
Schema::create('terms', function (Blueprint $table) {
$table->id();
$table->string('title'); // human friendly title
$table->longText('content')->nullable(); // the text (HTML allowed if you enable WYSIWYG)
$table->string('input_type')->default('textarea'); // optional: textarea, editor, boolean, etc.
$table->boolean('is_html')->default(false);
$table->integer('sort_order')->default(0);
$table->boolean('visible')->default(true);
$table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
$table->timestamps();
});
}


public function down(): void
{
Schema::dropIfExists('terms');
}
};