<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up(): void
{
    Schema::create('banks', function (Blueprint $table) {
        $table->id();
        $table->string('account_name');            // A/C NAME
        $table->string('account_no');              // A/C NO
        $table->string('iban')->nullable();        // IBAN
        $table->string('swift')->nullable();       // SWIFT
        $table->string('bank_name');               // bank name
        $table->text('bank_address')->nullable();  // bank address
        $table->string('correspondent_bank')->nullable();       // CORRESPONDENT BANK
        $table->string('correspondent_swift')->nullable();      // SWIFT OF CORRES/BANK
        $table->string('correspondent_account')->nullable();    // CORRESPONDENT A/C NO
        $table->timestamps();
    });
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('banks');
    }
};
