<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('quotations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('inquiry_id')->constrained('inquiries')->cascadeOnDelete();
            $table->string('quotation_number')->unique()->nullable();
            $table->json('costing_details')->nullable();

            $table->decimal('calculated_total_fabric_consumption', 10, 4)->nullable();
            $table->decimal('calculated_total_fabric_cost', 10, 2)->nullable();
            $table->decimal('calculated_accessories_cost', 10, 2)->nullable();
            $table->decimal('calculated_additional_costs_total', 10, 2)->nullable();
            $table->decimal('calculated_total_cost', 10, 2)->nullable();

            $table->decimal('quoted_price', 10, 2);
            $table->text('remarks')->nullable();
            $table->string('status')->default('draft');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('quotations');
    }
};
