<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inquiries', function (Blueprint $table) {
            $table->id();
            $table->foreignId('buyer_id')->constrained('buyers')->onDelete('cascade');
            $table->foreignId('brand_id')->constrained('brands')->cascadeOnDelete();
            $table->string('purchase_order_no');
            $table->string('style_number');
            $table->string('item_no');
            $table->foreignId('item_description_id')->constrained('item_descriptions')->cascadeOnDelete();
            $table->foreignId('size_range_id')->constrained('size_ranges')->cascadeOnDelete();
            $table->foreignId('color_id')->constrained('colors')->cascadeOnDelete();
            $table->integer('order_quantity');
            $table->foreignId('fabric_composition_id')->constrained('fabric_compositions')->cascadeOnDelete();
            $table->foreignId('fabric_type_id')->constrained('fabric_types')->cascadeOnDelete();
            $table->foreignId('yarn_count_id')->constrained('yarn_counts')->cascadeOnDelete();
            $table->foreignId('fabric_weight_id')->constrained('fabric_weights')->cascadeOnDelete();
            $table->date('shipment_date');
            $table->decimal('target_price', 10, 2)->nullable();
            $table->foreignId('port_of_landing_id')->constrained('port_of_landings')->cascadeOnDelete();
            $table->foreignId('country_of_origin_id')->constrained('country_of_origins')->cascadeOnDelete();
            $table->foreignId('port_of_discharge_id')->constrained('port_of_discharges')->cascadeOnDelete();
            $table->foreignId('final_destination_id')->constrained('final_destinations')->cascadeOnDelete();
            $table->foreignId('delivery_term_id')->constrained('delivery_terms')->cascadeOnDelete();
            $table->foreignId('shipment_mode_id')->constrained('shipment_modes')->cascadeOnDelete();
            $table->string('images')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inquiries');
    }
};
