<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rfq', function (Blueprint $table) {
            $table->id();
            $table->string('rfq_number')->unique()->nullable(); // Can be auto-generated
            $table->foreignId('buyer_id')->constrained('buyers')->onDelete('cascade');
            $table->foreignId('item_description_id')->constrained('item_descriptions')->cascadeOnDelete();
            $table->foreignId('brand_id')->nullable()->constrained('brands')->nullOnDelete();
            $table->foreignId('size_range_id')->constrained('size_ranges')->cascadeOnDelete();
            $table->foreignId('color_id')->constrained('colors')->cascadeOnDelete();
            $table->foreignId('fabric_composition_id')->constrained('fabric_compositions')->cascadeOnDelete();
            $table->foreignId('fabric_type_id')->constrained('fabric_types')->cascadeOnDelete();
            $table->foreignId('yarn_count_id')->constrained('yarn_counts')->cascadeOnDelete();
            $table->foreignId('fabric_weight_id')->constrained('fabric_weights')->cascadeOnDelete();
            
            $table->integer('quantity');
            $table->decimal('target_price', 8, 2)->nullable();
            
            $table->foreignId('port_of_landing_id')->constrained('port_of_landings')->cascadeOnDelete();
            $table->foreignId('country_of_origin_id')->constrained('country_of_origins')->cascadeOnDelete();
            $table->foreignId('port_of_discharge_id')->constrained('port_of_discharges')->cascadeOnDelete();
            $table->foreignId('final_destination_id')->constrained('final_destinations')->cascadeOnDelete();
            $table->foreignId('delivery_term_id')->constrained('delivery_terms')->cascadeOnDelete();
            $table->foreignId('shipment_mode_id')->constrained('shipment_modes')->cascadeOnDelete();
            $table->foreignId('payment_term_id')->constrained('payment_terms')->cascadeOnDelete();
            $table->foreignId('payment_mode_id')->constrained('payment_modes')->cascadeOnDelete();

            $table->text('remarks')->nullable();
            $table->string('status')->default('pending'); // e.g., pending, quoted, ordered, cancelled
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rfq');
    }
};
