<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rfq_accessories', function (Blueprint $table) {
    $table->id();
    $table->foreignId('rfq_id')->constrained('rfqs')->onDelete('cascade');
    $table->string('name');
    $table->integer('quantity');
    $table->decimal('rate', 10, 2);
    $table->decimal('total', 10, 2);
    $table->timestamps();
});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rfq_accessories');
    }
};
