<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       Schema::create('rfq_revisions', function (Blueprint $table) {
    $table->id();
    $table->foreignId('rfq_id')->constrained('rfqs')->onDelete('cascade');
    $table->string('revision_no'); // Rev 1, Rev 2
    $table->decimal('fabric_cost', 10, 2);
    $table->decimal('accessories_cost', 10, 2)->nullable();
    $table->decimal('other_costs', 10, 2)->nullable();
    $table->decimal('overhead_percent', 5, 2)->nullable();
    $table->decimal('margin_percent', 5, 2)->nullable();
    $table->decimal('final_price', 10, 2);
    $table->timestamps();
});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rfq_revisions');
    }
};
