<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
{
Schema::create('rfqs', function (Blueprint $table) {
    $table->id();
    $table->foreignId('buyer_id')->constrained('buyers')->onDelete('cascade');
    $table->string('style');
    $table->integer('quantity');

    $table->foreignId('fabric_id')->nullable()->constrained('information_libraries')->onDelete('set null');
    $table->string('gsm')->nullable();
   $table->decimal('wastage_percent', 5, 2)->nullable();
   $table->decimal('rate', 10, 2)->nullable();
    $table->date('delivery_date')->nullable();
    $table->string('image')->nullable();
    $table->enum('status', ['draft', 'submitted', 'approved', 'lost'])->default('draft');
    $table->timestamps();
});

}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rfqs');
    }
};
