<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */


public function up()
{
    Schema::create('information_libraries', function (Blueprint $table) {
        $table->id();
        $table->string('type'); // yarn, trim, dyeing, etc.
        $table->string('category')->nullable(); // fabric, trims, etc.
        $table->string('name'); // item name
        $table->string('gsm')->nullable(); // for yarn/fabric
        $table->decimal('wastage_percent', 5, 2)->nullable(); // for fabric
        $table->string('unit')->nullable(); // kg, pcs, %
        $table->decimal('rate', 10, 2)->nullable();
        $table->text('description')->nullable();
        $table->date('effective_from')->nullable();
        $table->enum('status', ['active', 'inactive'])->default('active');
        $table->timestamps();
    });
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('information_libraries');
    }
};
