<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('buyers', function (Blueprint $table) {
            $table->id();
            $table->string('company_name');
                    $table->foreignId('bank_id')->nullable()->constrained('banks')->nullOnDelete();
            $table->string('contact_person');
            $table->string('email')->unique();
            $table->string('phone')->nullable();
             $table->string('vat')->nullable();
            $table->string('fax')->nullable();
            $table->text('address')->nullable();
            $table->string('country')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
   public function down(): void
{
    Schema::table('buyers', function (Blueprint $table) {
        $table->dropForeign(['bank_id']);
        $table->dropColumn('bank_id');
    });
}
};
