<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       Schema::create('blog_comments', function (Blueprint $table) {
    $table->id();
    $table->foreignId('post_id')->constrained('blog_posts')->onDelete('cascade');
    $table->foreignId('parent_id')->nullable()->constrained('blog_comments')->onDelete('cascade');
    $table->string('name');
    $table->string('email');
    $table->text('comment');
    $table->timestamps();
});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blog_comments');
    }
};
