<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create("garment_addons", function (Blueprint $table) {
            $table->id();
            $table->string("name");
            $table->decimal("consumption", 10, 4)->comment("Consumption in kg or meters");
            $table->string("unit", 50)->default("kg");
            $table->enum("garment_type", ["top", "bottom", "both"])->default("both");
            $table->text("description")->nullable();
            $table->boolean("is_active")->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists("garment_addons");
    }
};


