<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create("other_costs", function (Blueprint $table) {
            $table->id();
            $table->string("name");
            $table->decimal("default_rate", 10, 2)->comment("Default rate in USD");
            $table->string("unit", 50)->default("dozen");
            $table->text("description")->nullable();
            $table->boolean("is_active")->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists("other_costs");
    }
};


