<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create("accessories", function (Blueprint $table) {
            $table->id();
            $table->string("name");
            $table->decimal("consumption_per_unit", 10, 4);
            $table->decimal("default_rate", 10, 2)->comment("Default rate in USD");
            $table->decimal("unit", 10, 2); // or 10, 4 if precision needed

            $table->text("description")->nullable();
            $table->boolean("is_active")->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists("accessories");
    }
};


