<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('order_confirmations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('quotation_id');
            $table->string('order_number')->unique();
            $table->string('customer_po_number')->nullable();
            $table->integer('confirmed_quantity');
           $table->string('pi_file')->nullable()->after('status');
            $table->decimal('confirmed_price', 10, 2);
            $table->date('delivery_date')->nullable();
            $table->text('payment_terms')->nullable();
            $table->text('special_instructions')->nullable();
            $table->enum('status', [
                'pending', 
                'confirmed', 
                'in_production', 
                'shipped', 
                'delivered', 
                'cancelled'
            ])->default('pending');
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
            
            // Foreign key constraints
            $table->foreign('quotation_id')->references('id')->on('quotations')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
            
            // Indexes
            $table->index('quotation_id');
            $table->index('status');
            $table->index('delivery_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_confirmations');
    }
};

